/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.RidingConditionalEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionAttributes;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParams;
import house.greenhouse.enchiridion.duck.Duck_EntityRidingEffects;
import house.greenhouse.enchiridion.duck.Duck_PostEntityDropParams;
import house.greenhouse.enchiridion.duck.Duck_ProjectileGravity;
import house.greenhouse.enchiridion.duck.Duck_Whirlpool;
import house.greenhouse.enchiridion.entity.Whirlpool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Triple;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class Mixin_Entity
implements Duck_EntityRidingEffects,
Duck_Whirlpool {
    @Unique
    private final List<Triple<EquipmentSlot, Integer, RidingConditionalEffect<EnchantmentLocationBasedEffect>>> enchiridion$activeRidingEffects = new ArrayList<Triple<EquipmentSlot, Integer, RidingConditionalEffect<EnchantmentLocationBasedEffect>>>();
    @Unique
    private float enchiridion$whirlpoolPercentage;
    @Unique
    private Whirlpool enchiridion$whirlpool;
    @Shadow
    private Level level;

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract boolean canFreeze();

    @ModifyReturnValue(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN", ordinal=2)})
    private ItemEntity enchiridion$postEntityDropEffectComponents(ItemEntity original) {
        Duck_PostEntityDropParams access;
        ServerLevel serverLevel;
        block7: {
            block6: {
                Entity thisAsEntity = (Entity)this;
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (thisAsEntity instanceof Duck_PostEntityDropParams && (access = (Duck_PostEntityDropParams)thisAsEntity).enchiridion$getPostEntityDropsParams() != null) break block7;
            }
            return original;
        }
        access.enchiridion$getPostEntityDropsParams().withParameter(EnchiridionLootContextParams.ITEM_ENTITY, (Object)original);
        access.enchiridion$getPostEntityDropsParams().withParameter(LootContextParams.ORIGIN, (Object)original.position());
        Entity entity = (Entity)access.enchiridion$getPostEntityDropsParams().getOptionalParameter(LootContextParams.ATTACKING_ENTITY);
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity attacker = (LivingEntity)entity;
        for (Object2IntMap.Entry enchantment : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), attacker.getWeaponItem()).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_ENTITY_DROP).isEmpty()).toList()) {
            access.enchiridion$getPostEntityDropsParams().withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantment.getIntValue());
            LootContext context = new LootContext.Builder(access.enchiridion$getPostEntityDropsParams().create(EnchiridionLootContextParamSets.ENCHANTED_ENTITY_DROP)).create(Optional.empty());
            for (ConditionalEffect effect : ((Enchantment)((Holder)enchantment.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_ENTITY_DROP)) {
                if (!effect.matches(context)) continue;
                ((EnchantmentEntityEffect)effect.effect()).apply(serverLevel, ((Integer)context.getParam(LootContextParams.ENCHANTMENT_LEVEL)).intValue(), new EnchantedItemInUse(attacker.getMainHandItem(), EquipmentSlot.MAINHAND, attacker), (Entity)original, original.position());
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"isFreezing"}, at={@At(value="RETURN")})
    private boolean enchiridion$setFreezingWhenEnchantment(boolean original) {
        return original || Enchiridion.getHelper().isFrozenByEnchantment((Entity)this) && this.canFreeze();
    }

    @ModifyReturnValue(method={"isStateClimbable"}, at={@At(value="RETURN")})
    private boolean enchiridion$allowClimbingAnyBlock(boolean original, @Local(argsOnly=true) BlockState state) {
        LivingEntity living;
        Entity entity;
        return original || (entity = (Entity)this) instanceof LivingEntity && (living = (LivingEntity)entity).getAttributeValue(EnchiridionAttributes.CLIMB_TIME) > 0.0 && !state.isAir();
    }

    @ModifyReturnValue(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="RETURN")})
    private boolean enchiridion$performRidingEffects(boolean original, Entity vehicle) {
        Entity thisAsEntity = (Entity)this;
        if (!this.level().isClientSide() && thisAsEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)thisAsEntity;
            if (original) {
                LootParams.Builder params = new LootParams.Builder((ServerLevel)living.level());
                params.withParameter(LootContextParams.THIS_ENTITY, (Object)living);
                params.withParameter(EnchiridionLootContextParams.VEHICLE, (Object)vehicle);
                params.withParameter(LootContextParams.ORIGIN, (Object)living.position());
                params.withOptionalParameter(EnchiridionLootContextParams.FIRST_PASSENGER, (Object)living.getFirstPassenger());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    for (Object2IntMap.Entry enchantment : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)living.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), living.getItemBySlot(slot)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot) && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.VEHICLE_CHANGED).isEmpty()).toList()) {
                        params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantment.getIntValue());
                        for (RidingConditionalEffect conditionalEffect : ((Enchantment)((Holder)enchantment.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.VEHICLE_CHANGED)) {
                            if (!conditionalEffect.matches(new LootContext.Builder(params.create(EnchiridionLootContextParamSets.ENCHANTED_VEHICLE)).create(Optional.empty()))) continue;
                            EnchantedItemInUse itemInUse = new EnchantedItemInUse(living.getItemBySlot(slot), slot, living);
                            for (Entity entity : conditionalEffect.affected().getEntities((Entity)living)) {
                                conditionalEffect.effect().onChangedBlock((ServerLevel)living.level(), enchantment.getIntValue(), itemInUse, entity, entity.position(), !this.enchiridion$activeRidingEffects.contains(Triple.of((Object)slot, (Object)enchantment.getIntValue(), (Object)conditionalEffect)));
                            }
                            this.enchiridion$addRidingEffect(slot, enchantment.getIntValue(), conditionalEffect);
                        }
                    }
                }
            }
        }
        return original;
    }

    @Inject(method={"removeVehicle"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;removePassenger(Lnet/minecraft/world/entity/Entity;)V")})
    private void enchiridion$removeRidingEffects(CallbackInfo ci) {
        this.enchiridion$resetRidingEffects();
    }

    @ModifyReturnValue(method={"getGravity"}, at={@At(value="RETURN")})
    public double enchiridion$modifyReturnValue(double original) {
        Entity entity = (Entity)this;
        if (entity instanceof Duck_ProjectileGravity) {
            Duck_ProjectileGravity arrowHand = (Duck_ProjectileGravity)entity;
            return arrowHand.enchiridion$getGravity().orElse(original);
        }
        return original;
    }

    @Override
    public void enchiridion$addRidingEffect(EquipmentSlot slot, int level, RidingConditionalEffect<EnchantmentLocationBasedEffect> effect) {
        this.enchiridion$activeRidingEffects.add((Triple<EquipmentSlot, Integer, RidingConditionalEffect<EnchantmentLocationBasedEffect>>)Triple.of((Object)slot, (Object)level, effect));
    }

    @Inject(method={"setPos(DDD)V"}, at={@At(value="TAIL")})
    public void enchiridion$updateWhirlpoolPosition(double x, double y, double z, CallbackInfo ci) {
        if (this.enchiridion$whirlpool != null) {
            this.enchiridion$whirlpool.setOldPosAndRot();
            this.enchiridion$whirlpool.setPos(x, y, z);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void enchiridion$removeWhirlpool(CallbackInfo ci) {
        if (this.enchiridion$whirlpool != null && this.enchiridion$whirlpool.isRemoved()) {
            this.enchiridion$whirlpoolPercentage = 0.0f;
            this.enchiridion$whirlpool = null;
        }
    }

    @Override
    public float enchiridion$whirlpoolPercentage() {
        return this.enchiridion$whirlpoolPercentage;
    }

    @Override
    public void enchiridion$setWhirlpoolPercentage(float value) {
        this.enchiridion$whirlpoolPercentage = value;
    }

    @Override
    public void enchiridion$setConnectedWhirlpool(Whirlpool whirlpool) {
        this.enchiridion$whirlpool = whirlpool;
    }

    @Override
    public void enchiridion$resetRidingEffects() {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).level().isClientSide()) {
            return;
        }
        for (Triple triple : this.enchiridion$activeRidingEffects) {
            for (Entity entity2 : ((RidingConditionalEffect)triple.getRight()).affected().getEntities((Entity)living)) {
                EnchantedItemInUse itemInUse = new EnchantedItemInUse(living.getItemBySlot((EquipmentSlot)triple.getLeft()), (EquipmentSlot)triple.getLeft(), living);
                ((RidingConditionalEffect)triple.getRight()).effect().onDeactivated(itemInUse, entity2, entity2.position(), ((Integer)triple.getMiddle()).intValue());
            }
        }
        this.enchiridion$activeRidingEffects.clear();
    }
}

