/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.block.EnchiridionFrostedIceBlock;
import house.greenhouse.enchiridion.block.entity.EnchiridionFrostedIceBlockEntity;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={FrostedIceBlock.class})
public class Mixin_FrostedIceBlock {
    @ModifyArgs(method={"onPlace"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"))
    private void enchiridion$setInitialCrackTime(Args args, @Local(argsOnly=true) Level level, @Local(argsOnly=true) BlockPos pos) {
        if ((FrostedIceBlock)this instanceof EnchiridionFrostedIceBlock) {
            args.set(1, (Object)level.getBlockEntity(pos, EnchiridionBlockEntityTypes.FROSTED_ICE).map(EnchiridionFrostedIceBlockEntity::getMinCrackTime).orElse(60));
            args.set(2, (Object)level.getBlockEntity(pos, EnchiridionBlockEntityTypes.FROSTED_ICE).map(EnchiridionFrostedIceBlockEntity::getMaxCrackTime).orElse(120));
        }
    }

    @Inject(method={"slightlyMelt"}, at={@At(value="HEAD")}, cancellable=true)
    private void enchiridion$modifyCrackChances(BlockState state, Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder params = new LootParams.Builder(serverLevel);
            params.withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter());
            if (!level.getEntities(EntityTypeTest.forClass(LivingEntity.class), AABB.ofSize((Vec3)pos.getCenter(), (double)16.0, (double)4.0, (double)16.0), living -> {
                float radius = 0.0f;
                params.withParameter(LootContextParams.THIS_ENTITY, living);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    Optional<Float> potential = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), living.getItemBySlot(slot)).entrySet().stream().map(entry -> {
                        params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                        return ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_ICE_CRACKS).stream().filter(effect -> effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()))).map(effect -> Float.valueOf(((LevelBasedValue)effect.effect()).calculate(entry.getIntValue()))).max(Comparator.comparingDouble(Float::doubleValue)).orElse(null);
                    }).filter(Objects::nonNull).max(Comparator.comparingDouble(Float::doubleValue));
                    if (!potential.isPresent() || !(radius < potential.get().floatValue())) continue;
                    radius = potential.get().floatValue();
                }
                if (radius < 0.001f) {
                    return false;
                }
                return living.position().distanceTo(pos.getCenter()) < (double)radius;
            }).isEmpty()) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if ((FrostedIceBlock)this instanceof EnchiridionFrostedIceBlock && level.getBlockEntity(pos, EnchiridionBlockEntityTypes.FROSTED_ICE).map(be -> be.getCrackChance() > level.getRandom().nextFloat()).orElse(false).booleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getMaxLocalRawBrightness(Lnet/minecraft/core/BlockPos;)I")})
    private int enchiridion$crackFrostedIceAtAllTimes(int original, @Local(argsOnly=true) BlockState state) {
        if ((FrostedIceBlock)this instanceof EnchiridionFrostedIceBlock && ((Boolean)state.getValue((Property)EnchiridionFrostedIceBlock.ALWAYS_TICK)).booleanValue()) {
            return Integer.MAX_VALUE;
        }
        return original;
    }

    @ModifyArgs(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"))
    private void enchiridion$tickEnchiridionFrostedIce(Args args, @Local(argsOnly=true) ServerLevel level, @Local(argsOnly=true) BlockPos pos) {
        if ((FrostedIceBlock)this instanceof EnchiridionFrostedIceBlock) {
            args.set(1, (Object)level.getBlockEntity(pos, EnchiridionBlockEntityTypes.FROSTED_ICE).map(EnchiridionFrostedIceBlockEntity::getMinCrackRate).orElse(20));
            args.set(2, (Object)level.getBlockEntity(pos, EnchiridionBlockEntityTypes.FROSTED_ICE).map(EnchiridionFrostedIceBlockEntity::getMaxCrackRate).orElse(40));
        }
    }
}

