/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.PreventHungerConsumptionEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.SweepParticleEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.util.WeaponUtil;
import house.greenhouse.enchiridion.duck.Duck_PlayerAttackStrength;
import house.greenhouse.enchiridion.duck.Duck_PlayerTarget;
import house.greenhouse.enchiridion.duck.Duck_ServerSmashDamageSource;
import house.greenhouse.enchiridion.network.clientbound.SyncSmashAttackSourceClientboundPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={Player.class})
public abstract class Mixin_Player
extends LivingEntity
implements Duck_PlayerTarget {
    @Unique
    private final Map<Holder<Enchantment>, Set<EnchantmentLocationBasedEffect>> enchiridion$activeBlockTargetEnchantmentEffects = new HashMap<Holder<Enchantment>, Set<EnchantmentLocationBasedEffect>>();
    @Unique
    private Entity enchiridion$sweepTarget;
    @Unique
    private DamageSource enchiridion$sweepDamageSource;

    protected Mixin_Player(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Shadow
    public abstract float getAttackStrengthScale(float var1);

    @ModifyExpressionValue(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z")})
    private boolean enchiridion$wrapExhaustionFromJumping(boolean original) {
        Player thisAsPlayer = (Player)this;
        return original && !PreventHungerConsumptionEffect.shouldPreventSprintingConsumption((LivingEntity)thisAsPlayer);
    }

    @WrapWithCondition(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V")})
    private boolean enchiridion$wrapExhaustionFromJumping(Player instance, float value) {
        return !PreventHungerConsumptionEffect.shouldPreventJumpingConsumption((LivingEntity)instance);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/player/Player;)Z")})
    private void enchiridion$storeMaceDamageSource(Entity target, CallbackInfo ci, @Local(ordinal=0) ItemStack stack, @Local DamageSource source) {
        Mixin_Player mixin_Player;
        if (stack.getItem() instanceof MaceItem && MaceItem.canSmashAttack((LivingEntity)this) && (mixin_Player = this) instanceof Duck_ServerSmashDamageSource) {
            Duck_ServerSmashDamageSource access = (Duck_ServerSmashDamageSource)((Object)mixin_Player);
            access.enchiridion$setSmashAttackSource(source);
            access.enchiridion$setSmashAttackTarget(target);
            Enchiridion.getHelper().sendClientboundTracking((Entity)this, new SyncSmashAttackSourceClientboundPacket(this.getId(), WeaponUtil.increaseMaceRadius(this, 3.5)));
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I", shift=At.Shift.AFTER)})
    private void enchiridion$resetAttackStrengthTicker(CallbackInfo ci) {
        Mixin_Player mixin_Player = this;
        if (mixin_Player instanceof Duck_PlayerAttackStrength) {
            Duck_PlayerAttackStrength access = (Duck_PlayerAttackStrength)((Object)mixin_Player);
            access.enchiridion$setAttackStrength(this.getAttackStrengthScale(0.0f));
        }
    }

    @Override
    public Map<Holder<Enchantment>, Set<EnchantmentLocationBasedEffect>> enchiridion$activeBlockTargetEnchantmentEffects() {
        return this.enchiridion$activeBlockTargetEnchantmentEffects;
    }

    @Override
    public void enchiridion$addActiveBlockTargetEnchantmentEffect(Holder<Enchantment> enchantment, EnchantmentLocationBasedEffect effect) {
        this.enchiridion$activeBlockTargetEnchantmentEffects.computeIfAbsent(enchantment, e -> new HashSet()).add(effect);
    }

    @Override
    public void enchiridion$removeActiveBlockTargetEnchantmentEffect(Holder<Enchantment> enchantment, EnchantmentLocationBasedEffect effect) {
        if (!this.enchiridion$activeBlockTargetEnchantmentEffects.containsKey(enchantment)) {
            return;
        }
        this.enchiridion$activeBlockTargetEnchantmentEffects.get(enchantment).remove(effect);
        if (this.enchiridion$activeBlockTargetEnchantmentEffects.get(enchantment).isEmpty()) {
            this.enchiridion$activeBlockTargetEnchantmentEffects.remove(enchantment);
        }
    }

    @Inject(method={"onEnchantmentPerformed"}, at={@At(value="TAIL")})
    private void enchiridion$clearEnchantments(ItemStack stack, int cost, CallbackInfo ci) {
        Enchiridion.getHelper().clearEnchantmentSeeds((Player)this);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;sweepAttack()V")})
    private void enchiridion$storeDamageSourceForSweepAttack(Entity target, CallbackInfo ci, @Local DamageSource source) {
        this.enchiridion$sweepTarget = target;
        this.enchiridion$sweepDamageSource = source;
    }

    @ModifyArgs(method={"sweepAttack"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I"))
    private void enchiridion$modifySweepAttack(Args args) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder params = new LootParams.Builder(serverLevel);
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)this.enchiridion$sweepTarget);
            params.withParameter(LootContextParams.ORIGIN, (Object)this.enchiridion$sweepTarget.position());
            params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.enchiridion$sweepDamageSource);
            params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.enchiridion$sweepDamageSource.getEntity());
            params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)this.enchiridion$sweepDamageSource.getDirectEntity());
            ItemStack weaponItem = this.getWeaponItem();
            ItemEnchantments itemEnchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), weaponItem);
            if (itemEnchantments != null && !itemEnchantments.isEmpty()) {
                EquipmentSlot slot = EquipmentSlot.MAINHAND;
                for (EquipmentSlot slot1 : EquipmentSlot.values()) {
                    if (!this.getItemBySlot(slot1).equals(weaponItem)) continue;
                    slot = slot1;
                    break;
                }
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    if (!((Enchantment)holder.value()).matchingSlot(slot)) continue;
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                    LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (ConditionalEffect effect : ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.SWEEP_PARTICLE)) {
                        if (!effect.matches(context)) continue;
                        ((SweepParticleEffect)effect.effect()).particle().ifPresent(particle -> args.set(0, particle));
                        ((SweepParticleEffect)effect.effect()).scale().ifPresent(scale -> {
                            double value = -1.0f - scale.process(entry.getIntValue(), this.random, 1.0f) * -1.0f;
                            args.set(5, (Object)1.0);
                            args.set(8, (Object)(-value * 2.0));
                        });
                    }
                }
            }
        }
    }
}

