/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import house.greenhouse.enchiridion.registry.EnchiridionBlocks;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SculkCatalystBlockEntity.CatalystListener.class})
public class Mixin_SculkCatalystBlockEntityCatalystListener {
    @Shadow
    @Final
    private PositionSource positionSource;

    @ModifyVariable(method={"handleGameEvent"}, at=@At(value="HEAD"), argsOnly=true)
    public Vec3 enchiridion$replaceSpreadTargetWithSiphoningTable(Vec3 pos, ServerLevel level, @Share(value="siphoningTable") LocalRef<Vec3> siphoningTable) {
        Optional nearestSiphoningTable = this.positionSource.getPosition((Level)level).flatMap(vec3 -> BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)vec3, (double)8.0, (double)6.0, (double)8.0)).filter(pos1 -> !pos1.closerToCenterThan((Position)vec3, 1.5) && level.getBlockState(pos1).is((Block)EnchiridionBlocks.SIPHONING_TABLE)).map(Vec3::atBottomCenterOf).min(Comparator.comparing(vec -> {
            Integer n;
            BlockEntity patt0$temp = level.getBlockEntity(BlockPos.containing((Position)vec));
            if (patt0$temp instanceof SiphoningTableBlockEntity) {
                SiphoningTableBlockEntity siphoningTableBlockEntity = (SiphoningTableBlockEntity)patt0$temp;
                n = siphoningTableBlockEntity.getExperience();
            } else {
                n = 15;
            }
            return n;
        })));
        nearestSiphoningTable.ifPresent(arg_0 -> siphoningTable.set(arg_0));
        return nearestSiphoningTable.orElse(pos);
    }

    @Inject(method={"handleGameEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Holder;is(Lnet/minecraft/core/Holder;)Z")}, cancellable=true)
    public void enchiridion$dontRunWhenSiphoningTableIsFull(ServerLevel level, Holder<GameEvent> gameEvent, GameEvent.Context context, Vec3 pos, CallbackInfoReturnable<Boolean> cir, @Share(value="siphoningTable") LocalRef<Vec3> siphoningTable) {
        SiphoningTableBlockEntity siphoningBlockEntity;
        BlockEntity blockEntity;
        if (siphoningTable.get() != null && (blockEntity = level.getBlockEntity(BlockPos.containing((Position)((Position)siphoningTable.get())))) instanceof SiphoningTableBlockEntity && (siphoningBlockEntity = (SiphoningTableBlockEntity)blockEntity).getExperience() >= 15) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapWithCondition(method={"handleGameEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/SculkCatalystBlockEntity$CatalystListener;tryAwardItSpreadsAdvancement(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V")})
    public boolean enchiridion$dontAwardAdvancementForSiphoningTable(SculkCatalystBlockEntity.CatalystListener instance, Level level, LivingEntity livingEntity, @Share(value="siphoningTable") LocalRef<Vec3> siphoningTable) {
        return siphoningTable.get() == null;
    }
}

