/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.effect.AttributeTransferEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.ConditionalSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.DirectionalSprintEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionAttributes;
import house.greenhouse.enchiridion.api.registry.EnchiridionBuiltInRegistries;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.api.util.ItemUtil;
import house.greenhouse.enchiridion.neoforge.mixin.Accessor_BuildCreativeModeTabContentsEvent;
import house.greenhouse.enchiridion.neoforge.platform.EnchiridionPlatformHelperNeoForge;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionAttachments;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionDataMaps;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionLootItemConditionsNeoForge;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionLootModifiers;
import house.greenhouse.enchiridion.network.clientbound.SendEnchantmentCategoryFromCommandClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncClientEnchantmentEntityEffectsClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantScrollIndexClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantedFrozenStateClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantmentLevelUpSeedsClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncItemUseDurationClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncSmashAttackSourceClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncSprintDirectionsClientboundPacket;
import house.greenhouse.enchiridion.network.serverbound.AttackEnchantmentEffectServerboundEnchantmentPacket;
import house.greenhouse.enchiridion.network.serverbound.SyncCurrentSprintDirectionServerboundPacket;
import house.greenhouse.enchiridion.network.serverbound.SyncEnchantScrollIndexServerboundPacket;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionBlockPredicateTypes;
import house.greenhouse.enchiridion.registry.EnchiridionBlocks;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentEntityEffectTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentProviderTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentValueEffectTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEntitySubPredicateTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionItemSubPredicates;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.registry.EnchiridionLootItemConditions;
import house.greenhouse.enchiridion.registry.EnchiridionLootItemFunctions;
import house.greenhouse.enchiridion.registry.EnchiridionMenuTypes;
import house.greenhouse.enchiridion.registry.EnchiridionParticleTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeSerializers;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.registry.EnchiridionSidedEntityEnchantmentEffectTypes;
import house.greenhouse.enchiridion.registry.EnchiridionSoundEvents;
import house.greenhouse.enchiridion.util.ClientRegistryAccessReference;
import house.greenhouse.enchiridion.util.CreativeTabUtil;
import house.greenhouse.enchiridion.util.EntityUtil;
import house.greenhouse.enchiridion.util.VillagerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.util.InsertableLinkedOpenCustomHashSet;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod(value="enchiridion")
public class EnchiridionNeoForge {
    public static boolean isClient;

    public EnchiridionNeoForge(IEventBus eventBus) {
        Enchiridion.init(new EnchiridionPlatformHelperNeoForge());
        EnchiridionDataMaps.init();
    }

    public static PackSource createSource(final boolean enabledByDefault) {
        return new PackSource(){

            @NotNull
            public Component decorate(@NotNull Component component) {
                return Component.translatable((String)"pack.enchiridion.builtin", (Object[])new Object[]{component});
            }

            public boolean shouldAddAutomatically() {
                return enabledByDefault;
            }
        };
    }

    public static RegistryAccess getRegistryAccess() {
        if (EffectiveSide.get().isClient()) {
            return ClientRegistryAccessReference.get(null);
        }
        return Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).registryAccess();
    }

    @EventBusSubscriber(modid="enchiridion", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
            for (EntityType type : event.getTypes()) {
                event.add(type, EnchiridionAttributes.CLIMB_SPEED);
                event.add(type, EnchiridionAttributes.CLIMB_TIME);
                event.add(type, EnchiridionAttributes.FRICTION_MULTIPLIER);
                event.add(type, EnchiridionAttributes.JUMP_EXTENSION_TIME);
                event.add(type, EnchiridionAttributes.SPRINT_JUMP_VELOCITY_MULTIPLIER);
                event.add(type, EnchiridionAttributes.USING_ITEM_SPRINT_SPEED);
            }
        }

        @SubscribeEvent
        public static void modifyDefaultComponents(ModifyDefaultComponentsEvent event) {
            event.modify((ItemLike)Items.ENCHANTED_BOOK, builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)16));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void modifyCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
                CreativeTabUtil.addSiphoningTableToCreativeMenu((arg_0, arg_1, arg_2) -> ((BuildCreativeModeTabContentsEvent)event).insertAfter(arg_0, arg_1, arg_2));
            }
            CreativeTabUtil.sortEnchantmentsBasedOnCategory(event.getParentEntries().stream().toList(), stacks -> {
                InsertableLinkedOpenCustomHashSet<ItemStack> tabStacks = ((Accessor_BuildCreativeModeTabContentsEvent)event).enchiridion$getParentEntries();
                tabStacks.clear();
                tabStacks.addAll((Collection)stacks);
            }, event.getParameters().holders());
            CreativeTabUtil.sortEnchantmentsBasedOnCategory(event.getSearchEntries().stream().toList(), stacks -> {
                InsertableLinkedOpenCustomHashSet<ItemStack> tabStacks = ((Accessor_BuildCreativeModeTabContentsEvent)event).enchiridion$getSearchEntries();
                tabStacks.clear();
                tabStacks.addAll((Collection)stacks);
            }, event.getParameters().holders());
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            event.registrar("1.0.0").playToClient(SendEnchantmentCategoryFromCommandClientboundPacket.TYPE, SendEnchantmentCategoryFromCommandClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncClientEnchantmentEntityEffectsClientboundPacket.TYPE, SyncClientEnchantmentEntityEffectsClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncEnchantedFrozenStateClientboundPacket.TYPE, SyncEnchantedFrozenStateClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncEnchantScrollIndexClientboundPacket.TYPE, SyncEnchantScrollIndexClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncEnchantmentLevelUpSeedsClientboundPacket.TYPE, SyncEnchantmentLevelUpSeedsClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncItemUseDurationClientboundPacket.TYPE, SyncItemUseDurationClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncSmashAttackSourceClientboundPacket.TYPE, SyncSmashAttackSourceClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToClient(SyncSprintDirectionsClientboundPacket.TYPE, SyncSprintDirectionsClientboundPacket.STREAM_CODEC, (packet, context) -> packet.handle()).playToServer(AttackEnchantmentEffectServerboundEnchantmentPacket.TYPE, AttackEnchantmentEffectServerboundEnchantmentPacket.STREAM_CODEC, (packet, context) -> packet.handle((ServerPlayer)context.player())).playToServer(SyncCurrentSprintDirectionServerboundPacket.TYPE, SyncCurrentSprintDirectionServerboundPacket.STREAM_CODEC, (packet, context) -> packet.handle((ServerPlayer)context.player())).playToServer(SyncEnchantScrollIndexServerboundPacket.TYPE, SyncEnchantScrollIndexServerboundPacket.STREAM_CODEC, (packet, context) -> packet.handle((ServerPlayer)context.player()));
        }

        @SubscribeEvent
        public static void registerContent(RegisterEvent event) {
            ModEvents.register(event, Registries.ATTRIBUTE, EnchiridionAttributes::registerAll);
            ModEvents.register(event, Registries.BLOCK, EnchiridionBlocks::registerAll);
            ModEvents.register(event, Registries.BLOCK_ENTITY_TYPE, EnchiridionBlockEntityTypes::registerAll);
            ModEvents.register(event, Registries.BLOCK_PREDICATE_TYPE, EnchiridionBlockPredicateTypes::registerAll);
            ModEvents.register(event, Registries.DATA_COMPONENT_TYPE, EnchiridionDataComponents::registerAll);
            ModEvents.register(event, Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, EnchiridionEnchantmentEffectComponents::registerAll);
            ModEvents.register(event, Registries.ENCHANTMENT_PROVIDER_TYPE, EnchiridionEnchantmentProviderTypes::registerAll);
            ModEvents.register(event, Registries.ENCHANTMENT_VALUE_EFFECT_TYPE, EnchiridionEnchantmentValueEffectTypes::registerAll);
            ModEvents.register(event, Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, EnchiridionEnchantmentEntityEffectTypes::registerEntityEffects);
            ModEvents.register(event, Registries.ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE, EnchiridionEnchantmentEntityEffectTypes::registerLocationBasedEffects);
            ModEvents.register(event, Registries.ENTITY_SUB_PREDICATE_TYPE, EnchiridionEntitySubPredicateTypes::registerAll);
            ModEvents.register(event, Registries.ENTITY_TYPE, EnchiridionEntityTypes::registerAll);
            ModEvents.register(event, Registries.ITEM, EnchiridionItems::registerAll);
            ModEvents.register(event, Registries.ITEM_SUB_PREDICATE_TYPE, EnchiridionItemSubPredicates::registerAll);
            ModEvents.register(event, Registries.MENU, EnchiridionMenuTypes::registerAll);
            ModEvents.register(event, Registries.LOOT_CONDITION_TYPE, EnchiridionLootItemConditions::registerAll);
            ModEvents.register(event, Registries.LOOT_CONDITION_TYPE, EnchiridionLootItemConditionsNeoForge::registerAll);
            ModEvents.register(event, Registries.LOOT_FUNCTION_TYPE, EnchiridionLootItemFunctions::registerAll);
            ModEvents.register(event, Registries.PARTICLE_TYPE, EnchiridionParticleTypes::registerAll);
            ModEvents.register(event, Registries.RECIPE_SERIALIZER, EnchiridionRecipeSerializers::registerAll);
            ModEvents.register(event, Registries.RECIPE_TYPE, EnchiridionRecipeTypes::registerAll);
            ModEvents.register(event, Registries.SOUND_EVENT, EnchiridionSoundEvents::registerAll);
            ModEvents.register(event, EnchiridionRegistries.SIDED_ENCHANTMENT_ENTITY_EFFECT, EnchiridionSidedEntityEnchantmentEffectTypes::registerAll);
            ModEvents.register(event, NeoForgeRegistries.Keys.ATTACHMENT_TYPES, EnchiridionAttachments::registerAll);
            ModEvents.register(event, NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, EnchiridionLootModifiers::registerAll);
        }

        private static <T> void register(RegisterEvent event, ResourceKey<Registry<T>> registryKey, Runnable runnable) {
            if (event.getRegistryKey() == registryKey) {
                runnable.run();
            }
        }

        @SubscribeEvent
        public static void newRegistry(NewRegistryEvent event) {
            event.register(EnchiridionBuiltInRegistries.SIDED_ENCHANTMENT_ENTITY_EFFECT);
        }

        @SubscribeEvent
        public static void newDataPackRegistry(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(EnchiridionRegistries.ENCHANTMENT_CATEGORY, EnchantmentCategory.DIRECT_CODEC, EnchantmentCategory.DIRECT_CODEC);
        }

        @SubscribeEvent
        public static void registerDataMapTypes(RegisterDataMapTypesEvent event) {
            event.register(EnchiridionDataMaps.SKULLS);
            event.register(EnchiridionDataMaps.SPLITTING);
        }

        @SubscribeEvent
        public static void addPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.SERVER_DATA) {
                event.addPackFinders(Enchiridion.id("resourcepacks/vanilla_balancing"), PackType.SERVER_DATA, (Component)Component.translatable((String)"dataPack.enchiridion.vanilla_balancing.name"), EnchiridionNeoForge.createSource(false), false, Pack.Position.TOP);
                event.addPackFinders(Enchiridion.id("resourcepacks/vanilla_enchantment_modifications"), PackType.SERVER_DATA, (Component)Component.translatable((String)"dataPack.enchiridion.vanilla_enchantment_modifications.name"), EnchiridionNeoForge.createSource(true), false, Pack.Position.TOP);
            }
        }
    }

    @EventBusSubscriber(modid="enchiridion", bus=EventBusSubscriber.Bus.GAME)
    public static class GameEvents {
        private static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> VANILLA_EXPERIMENTAL_TRADES = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>>();

        @SubscribeEvent
        public static void onVillagerTrades(VillagerTradesEvent event) {
            if (event.getType() == VillagerProfession.LIBRARIAN) {
                event.getTrades().compute(1, (i, trades) -> VillagerUtil.modifyNoviceLibrarianTradeOffers(trades));
                event.getTrades().compute(2, (i, trades) -> VillagerUtil.modifyApprenticeLibrarianTradeOffers(trades));
                event.getTrades().compute(3, (i, trades) -> VillagerUtil.modifyJourneymanLibrarianTradeOffers(trades));
                event.getTrades().compute(4, (i, trades) -> VillagerUtil.modifyExpertLibrarianTradeOffers(trades));
                event.getTrades().compute(5, (i, trades) -> VillagerUtil.modifyMasterLibrarianTradeOffers(trades));
            } else if (!(event.getType() != VillagerProfession.ARMORER || ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().getWorldData().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE))) {
                event.getTrades().compute(4, (i, trades) -> VillagerUtil.modifyExpertArmorerTradeOffers(trades, false));
                event.getTrades().compute(5, (i, trades) -> VillagerUtil.modifyMasterArmorerTradeOffers(trades, false));
            } else if (event.getType() == VillagerProfession.TOOLSMITH) {
                event.getTrades().compute(3, (i, trades) -> VillagerUtil.modifyJourneymanToolsmithTradeOffers(trades, false));
                event.getTrades().compute(4, (i, trades) -> VillagerUtil.modifyExpertToolsmithTradeOffers(trades, false));
                event.getTrades().compute(5, (i, trades) -> VillagerUtil.modifyMasterToolsmithTradeOffers(trades, false));
            } else if (event.getType() == VillagerProfession.WEAPONSMITH) {
                event.getTrades().compute(1, (i, trades) -> VillagerUtil.modifyNoviceWeaponsmithTradeOffers(trades, false));
                event.getTrades().compute(4, (i, trades) -> VillagerUtil.modifyExpertWeaponsmithTradeOffers(trades, false));
                event.getTrades().compute(5, (i, trades) -> VillagerUtil.modifyMasterWeaponsmithTradeOffers(trades, false));
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onTagsUpdated(TagsUpdatedEvent event) {
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().getWorldData().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE)) {
                if (VANILLA_EXPERIMENTAL_TRADES.isEmpty()) {
                    VANILLA_EXPERIMENTAL_TRADES.putAll(VillagerTrades.EXPERIMENTAL_TRADES);
                }
                for (VillagerProfession prof : BuiltInRegistries.VILLAGER_PROFESSION) {
                    Int2ObjectMap<VillagerTrades.ItemListing[]> experimentalTrades = VANILLA_EXPERIMENTAL_TRADES.getOrDefault(prof, (Int2ObjectMap<VillagerTrades.ItemListing[]>)new Int2ObjectOpenHashMap());
                    Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
                    for (int i = 1; i < 6; ++i) {
                        mutableTrades.put(i, (Object)NonNullList.create());
                    }
                    experimentalTrades.int2ObjectEntrySet().forEach(arg_0 -> GameEvents.lambda$onTagsUpdated$13((Int2ObjectMap)mutableTrades, arg_0));
                    GameEvents.modifyExperimentalVillagerTrades(prof, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)mutableTrades);
                    Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
                    mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> GameEvents.lambda$onTagsUpdated$14((Int2ObjectMap)newTrades, arg_0));
                    if (newTrades.isEmpty()) continue;
                    VillagerTrades.EXPERIMENTAL_TRADES.put(prof, newTrades);
                }
            }
        }

        private static void modifyExperimentalVillagerTrades(VillagerProfession prof, Int2ObjectMap<List<VillagerTrades.ItemListing>> mutableTrades) {
            if (prof == VillagerProfession.LIBRARIAN) {
                mutableTrades.compute(1, (i, trades) -> VillagerUtil.modifyNoviceLibrarianTradeOffers(trades));
                mutableTrades.compute(2, (i, trades) -> VillagerUtil.modifyApprenticeLibrarianTradeOffers(trades));
                mutableTrades.compute(3, (i, trades) -> VillagerUtil.modifyJourneymanLibrarianTradeOffers(trades));
                mutableTrades.compute(4, (i, trades) -> VillagerUtil.modifyExpertLibrarianTradeOffers(trades));
                mutableTrades.compute(5, (i, trades) -> VillagerUtil.modifyMasterLibrarianTradeOffers(trades));
            } else if (prof == VillagerProfession.ARMORER) {
                mutableTrades.compute(4, (i, trades) -> VillagerUtil.modifyExpertArmorerTradeOffers(trades, true));
                mutableTrades.compute(5, (i, trades) -> VillagerUtil.modifyMasterArmorerTradeOffers(trades, true));
            }
        }

        @SubscribeEvent
        public static void livingGetProjectileEvent(LivingGetProjectileEvent event) {
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (event.getProjectileItemStack().isEmpty()) {
                    Item item;
                    LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)event.getProjectileWeaponItemStack());
                    if (Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), event.getProjectileWeaponItemStack()).entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ALLOW_FIRING_WITHOUT_AMMO).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ALLOW_FIRING_WITHOUT_AMMO).stream().anyMatch(effect -> {
                        params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                        return effect.map(condition -> condition.test((Object)new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))).orElse(true);
                    })) && (item = event.getProjectileWeaponItemStack().getItem()) instanceof ProjectileWeaponItem) {
                        Player player;
                        ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item;
                        item = event.getEntity();
                        event.setProjectileItemStack(weaponItem.getDefaultCreativeAmmo(item instanceof Player ? (player = (Player)item) : null, event.getProjectileWeaponItemStack()));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamagePost(LivingDamageEvent.Post event) {
            if (event.getSource().getDirectEntity() != null) {
                Enchiridion.getHelper().setPreviousAttacKTarget(event.getSource().getDirectEntity(), (Entity)event.getEntity());
            }
            int airTime = Enchiridion.getHelper().getAirTime((Entity)event.getEntity());
            if ((double)event.getNewDamage() > 0.0 && airTime > -1) {
                Enchiridion.getHelper().setAirTime((Entity)event.getEntity(), (int)(event.getEntity().getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0));
            }
        }

        @SubscribeEvent
        public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
            int airTime = Enchiridion.getHelper().getAirTime((Entity)event.getEntity());
            if (airTime > -1) {
                Enchiridion.getHelper().setAirTime((Entity)event.getEntity(), (int)(event.getEntity().getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0));
            }
        }

        @SubscribeEvent
        public static void onEntityTick(EntityTickEvent.Pre event) {
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityUtil.setStackHoldersToEntity(living);
                AttributeTransferEffect.apply(living);
                ItemUtil.autoUse(living);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DirectionalSprintEffect.serverTick(serverPlayer);
                BlockHitResult hitResult = serverPlayer.level().clip(new ClipContext(serverPlayer.getEyePosition(), serverPlayer.getEyePosition().add(serverPlayer.getViewVector(1.0f).multiply(serverPlayer.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), serverPlayer.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), serverPlayer.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE))), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)serverPlayer));
                if (hitResult.getType() == HitResult.Type.MISS) {
                    Predicate<Entity> predicate;
                    AABB aabb;
                    Vec3 vec31;
                    Vec3 vec32;
                    double distance = serverPlayer.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
                    Vec3 vec3 = serverPlayer.getEyePosition();
                    EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)serverPlayer, (Vec3)vec3, (Vec3)(vec32 = vec3.add(vec31 = serverPlayer.getViewVector(1.0f).scale(distance))), (AABB)(aabb = serverPlayer.getBoundingBox().expandTowards(vec31).inflate(1.0)), predicate = p_113447_ -> !p_113447_.isSpectator() && p_113447_.isPickable(), (double)(distance * distance));
                    if (entityHitResult != null) {
                        hitResult = entityHitResult;
                    }
                }
                ConditionalSidedEnchantmentEntityEffect.tickConditionsWithEntityParamSet((LivingEntity)event.getEntity(), hitResult.getLocation(), EnchiridionEnchantmentEffectComponents.HIT_ATTACK, EnchiridionEnchantmentEffectComponents.MISSED_ATTACK);
            }
        }

        private static /* synthetic */ void lambda$onTagsUpdated$14(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
            newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new VillagerTrades.ItemListing[0]));
        }

        private static /* synthetic */ void lambda$onTagsUpdated$13(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
            Arrays.stream((VillagerTrades.ItemListing[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
        }
    }
}

