/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.LootEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.mixin.Accessor_LootParams;
import house.greenhouse.enchiridion.neoforge.mixin.Accessor_LootContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EnchantedBlockLootModifier
extends LootModifier {
    public static final MapCodec<EnchantedBlockLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions)).apply((Applicative)inst, EnchantedBlockLootModifier::new));
    private static LootContext originalContext;

    public EnchantedBlockLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootParams.Builder paramBuilder = new LootParams.Builder(context.getLevel());
        if (!((Accessor_LootParams)((Accessor_LootContext)context).enchiridion$getParams()).enchiridion$getParams().keySet().containsAll(LootContextParamSets.BLOCK.getRequired())) {
            return generatedLoot;
        }
        for (Map.Entry<LootContextParam<?>, Object> param : ((Accessor_LootParams)((Accessor_LootContext)context).enchiridion$getParams()).enchiridion$getParams().entrySet()) {
            paramBuilder.withParameter(param.getKey(), param.getValue());
        }
        if (context.hasParam(LootContextParams.TOOL)) {
            EquipmentSlot slot = EquipmentSlot.MAINHAND;
            for (Map.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), (ItemStack)context.getParam(LootContextParams.TOOL)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.BLOCK_LOOT).isEmpty() && (!context.hasParam(LootContextParams.THIS_ENTITY) || ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot))).toList()) {
                paramBuilder.withOptionalParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Integer)entry2.getValue()));
                LootParams params2 = paramBuilder.create(EnchiridionLootContextParamSets.ENCHANTED_BLOCK);
                for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.BLOCK_LOOT)) {
                    Optional holder = context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE).getHolder(context.getQueriedLootTableId());
                    LootContext blockContext = new LootContext.Builder(params2).withQueriedLootTableId(((LootEffect)effect.effect()).lootTable().map(ResourceKey::location).orElse(context.getQueriedLootTableId())).create(Optional.empty());
                    if (holder.isEmpty() || originalContext != null && originalContext != context || !effect.matches(blockContext) || ((LootEffect)effect.effect()).lootTables().isPresent() && ((LootEffect)effect.effect()).lootTables().map(either -> (Boolean)either.map(tableTagKey -> !((Holder.Reference)holder.get()).is(tableTagKey), resourceKeys -> resourceKeys.stream().anyMatch(resourceKey -> ((Holder.Reference)holder.get()).is(resourceKey)))).orElse(false).booleanValue()) continue;
                    if (!((LootEffect)effect.effect()).add()) {
                        generatedLoot.clear();
                    }
                    if (((LootEffect)effect.effect()).add() || ((LootEffect)effect.effect()).lootTable().isPresent()) {
                        generatedLoot.addAll((ObjectList)blockContext.getLevel().getServer().reloadableRegistries().getLootTable(((LootEffect)effect.effect()).lootTable().orElse((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)context.getQueriedLootTableId()))).getRandomItems(params2, params2.getLevel().getRandom()));
                    }
                    originalContext = context;
                }
            }
        }
        if (originalContext == context) {
            originalContext = null;
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

