/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.network.clientbound;

import house.greenhouse.enchiridion.Enchiridion;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record SyncEnchantmentLevelUpSeedsClientboundPacket(int entityId, int index, int seed, boolean clear) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Enchiridion.id("sync_enchantment_level_up_seeds");
    public static final CustomPacketPayload.Type<SyncEnchantmentLevelUpSeedsClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, SyncEnchantmentLevelUpSeedsClientboundPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncEnchantmentLevelUpSeedsClientboundPacket::write, SyncEnchantmentLevelUpSeedsClientboundPacket::new);

    public SyncEnchantmentLevelUpSeedsClientboundPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    public static SyncEnchantmentLevelUpSeedsClientboundPacket add(int entityId, int index, int seed) {
        return new SyncEnchantmentLevelUpSeedsClientboundPacket(entityId, index, seed, false);
    }

    public static SyncEnchantmentLevelUpSeedsClientboundPacket clear(int entityId) {
        return new SyncEnchantmentLevelUpSeedsClientboundPacket(entityId, -1, -1, true);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.index);
        buf.writeInt(this.seed);
        buf.writeBoolean(this.clear);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (this.clear) {
                Enchiridion.getHelper().clearEnchantmentSeeds(player);
            } else {
                Enchiridion.getHelper().addEnchantmentSeed(player, this.index, this.seed);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

