/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.registry;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchiridionEnchantmentCategories {
    public static final ResourceKey<EnchantmentCategory> PRIMARY = ResourceKey.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY, (ResourceLocation)Enchiridion.id("primary"));
    public static final ResourceKey<EnchantmentCategory> SECONDARY = ResourceKey.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY, (ResourceLocation)Enchiridion.id("secondary"));
    public static final ResourceKey<EnchantmentCategory> TERTIARY = ResourceKey.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY, (ResourceLocation)Enchiridion.id("tertiary"));
    public static final ResourceKey<EnchantmentCategory> UNCATEGORISED = ResourceKey.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY, (ResourceLocation)Enchiridion.id("uncategorised"));
    public static final ResourceKey<EnchantmentCategory> CURSE = ResourceKey.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY, (ResourceLocation)Enchiridion.id("curse"));

    public static void bootstrap(BootstrapContext<EnchantmentCategory> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        EnchantmentCategory primary = EnchantmentCategory.builder((HolderSet<Enchantment>)enchantments.getOrThrow(EnchiridionTags.EnchantmentTags.PRIMARY_CATEGORY), new CategoryVisuals(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD), 0.1f)).limit(1).priority(30).build(PRIMARY.location());
        EnchantmentCategory secondary = EnchantmentCategory.builder((HolderSet<Enchantment>)enchantments.getOrThrow(EnchiridionTags.EnchantmentTags.SECONDARY_CATEGORY), new CategoryVisuals(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE), 0.2f)).limit(1).priority(20).build(SECONDARY.location());
        EnchantmentCategory tertiary = EnchantmentCategory.builder((HolderSet<Enchantment>)enchantments.getOrThrow(EnchiridionTags.EnchantmentTags.TERTIARY_CATEGORY), new CategoryVisuals(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_GREEN), 0.3f)).limit(1).priority(10).build(TERTIARY.location());
        EnchantmentCategory uncategorised = EnchantmentCategory.builder((HolderSet<Enchantment>)enchantments.getOrThrow(EnchiridionTags.EnchantmentTags.UNCATEGORISED_CATEGORY), new CategoryVisuals(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY), 0.4f)).priority(0).build(UNCATEGORISED.location());
        EnchantmentCategory curse = EnchantmentCategory.builder((HolderSet<Enchantment>)enchantments.getOrThrow(EnchantmentTags.CURSE), new CategoryVisuals(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED))).priority(-10).tradeChance(0.075f).build(CURSE.location());
        context.register(PRIMARY, (Object)primary);
        context.register(SECONDARY, (Object)secondary);
        context.register(TERTIARY, (Object)tertiary);
        context.register(UNCATEGORISED, (Object)uncategorised);
        context.register(CURSE, (Object)curse);
    }
}

