/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.util.AnvilUtil;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class AllowEnchantingUtil {
    public static boolean shouldCancelEnchanting(Holder<Enchantment> enchantment, ItemStack target) {
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)target.get(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES);
        if (categories == null) {
            return false;
        }
        Holder<EnchantmentCategory> category = EnchantmentCategoryUtil.getFirstEnchantmentCategory((HolderLookup.Provider)Enchiridion.getHelper().getReqistryAccess(), enchantment);
        if (category == null) {
            return false;
        }
        return !AnvilUtil.getAnvilContext() && (target.is(EnchiridionTags.ItemTags.STORED_ENCHANTABLES) || !EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsWithValue(category, categories, enchantment));
    }

    public static boolean isEnchantmentItemExcluded(RegistryAccess access, Holder<Enchantment> enchantment, ItemStack target) {
        HolderLookup.RegistryLookup itemLookup = access.lookupOrThrow(Registries.ITEM);
        return access.lookupOrThrow(Registries.ENCHANTMENT).listTags().filter(AllowEnchantingUtil::isItemExclusionTag).anyMatch(arg_0 -> AllowEnchantingUtil.lambda$isEnchantmentItemExcluded$0(enchantment, (HolderLookup)itemLookup, target, arg_0));
    }

    private static boolean isItemExclusionTag(HolderSet.Named<Enchantment> enchantmentTag) {
        ResourceLocation tagKey = enchantmentTag.key().location();
        return tagKey.getPath().startsWith("enchiridion/item_excluded_set/") && tagKey.getPath().substring(30).split("/").length > 1;
    }

    private static boolean isTagBasedExclusion(HolderSet.Named<Enchantment> enchantmentTag) {
        ResourceLocation tagKey = enchantmentTag.key().location();
        return tagKey.getPath().startsWith("enchiridion/item_excluded_set/tag/");
    }

    private static boolean isItemApplicable(TagKey<Enchantment> enchantmentTag, Holder<Item> item) {
        Optional itemKey = item.unwrapKey();
        if (itemKey.isEmpty()) {
            return false;
        }
        String[] splitEnchantment = enchantmentTag.location().getPath().substring(30).split("/", 2);
        String[] splitItem = new String[]{((ResourceKey)itemKey.get()).location().getNamespace(), ((ResourceKey)itemKey.get()).location().getPath()};
        return splitItem[0].equals(splitEnchantment[0]) && splitItem[1].equals(splitEnchantment[1]);
    }

    private static TagKey<Item> mapEnchantmentTagToItem(HolderSet.Named<Enchantment> enchantmentTag) {
        ResourceLocation tagKey = enchantmentTag.key().location();
        String[] split = tagKey.getPath().substring(34).split("/", 2);
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)split[0], (String)split[1]));
    }

    private static /* synthetic */ boolean lambda$isEnchantmentItemExcluded$0(Holder enchantment, HolderLookup itemLookup, ItemStack target, HolderSet.Named holders) {
        if (!holders.contains(enchantment)) {
            return false;
        }
        if (AllowEnchantingUtil.isTagBasedExclusion((HolderSet.Named<Enchantment>)holders)) {
            TagKey<Item> itemTagKey = AllowEnchantingUtil.mapEnchantmentTagToItem((HolderSet.Named<Enchantment>)holders);
            Optional itemTag = itemLookup.get(itemTagKey);
            return itemTag.isPresent() && ((HolderSet.Named)itemTag.get()).contains(target.getItemHolder());
        }
        return AllowEnchantingUtil.isItemApplicable((TagKey<Enchantment>)holders.key(), (Holder<Item>)target.getItemHolder());
    }
}

