/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.google.common.collect.Lists;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.enchantment.provider.EnchantFromTable;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentProviders;
import house.greenhouse.enchiridion.util.EnchantmentInstanceWithCategory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.LevelAccessor;

public class EnchantingTableUtil {
    public static int getLevelUpCost(int level, int maxLevel) {
        return (int)((float)level / (float)maxLevel * 25.0f) - (int)((float)(21 - 4 * level) / 3.0f);
    }

    public static int getMinimumBookshelfAmountForLevelling(int level, int maxLevel) {
        return (int)((float)level / (float)maxLevel * 15.0f) - (int)((float)(15.0 - 2.7 * (double)level) / 3.0f);
    }

    public static int getLapisCountForLevelling(int level, int maxLevel) {
        return Math.max(1, (int)((float)level / (float)maxLevel * (float)Math.min(maxLevel, 3)));
    }

    public static int getEnchantmentCost(int value) {
        return Math.round((float)value * ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().costMultiplier());
    }

    public static int getEnchantmentEffectiveness(int value) {
        return Math.round((float)value / ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().costMultiplier() * ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().effectivenessMultiplier());
    }

    public static List<EnchantmentInstance> getEnchantments(RandomSource random, LevelAccessor levelAccessor, BlockPos pos, ItemStack stack, int slot, int cost, int enchantmentSeed) {
        random.setSeed((long)(enchantmentSeed + slot));
        List<EnchantmentInstance> list = EnchantingTableUtil.selectEnchantment(random, levelAccessor, stack, cost, pos);
        if (stack.is(Items.BOOK) && list.size() > 1) {
            list.remove(random.nextInt(list.size()));
        }
        return list;
    }

    private static List<EnchantmentInstance> selectEnchantment(RandomSource random, LevelAccessor levelAccessor, ItemStack stack, int level, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.getItem();
        int i = item.getEnchantmentValue();
        if (i <= 0) {
            return list;
        }
        level += 1 + random.nextInt(i / 4 + 1) + random.nextInt(i / 4 + 1);
        float f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        level = Mth.clamp((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE);
        ResourceKey<EnchantmentProvider> providerKey = EnchiridionEnchantmentProviders.ENCHANTING_LOW_LEVEL;
        if (level > EnchantingTableUtil.getEnchantmentEffectiveness(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().highLevelMin())) {
            providerKey = EnchiridionEnchantmentProviders.ENCHANTING_HIGH_LEVEL;
        } else if (level > EnchantingTableUtil.getEnchantmentEffectiveness(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().mediumLevelMin())) {
            providerKey = EnchiridionEnchantmentProviders.ENCHANTING_MEDIUM_LEVEL;
        }
        Optional provider = levelAccessor.registryAccess().registryOrThrow(Registries.ENCHANTMENT_PROVIDER).getHolder(providerKey);
        if (provider.isEmpty()) {
            return list;
        }
        Object object = ((Holder.Reference)provider.get()).value();
        if (object instanceof EnchantFromTable) {
            EnchantFromTable enchantingTableProvider = (EnchantFromTable)object;
            enchantingTableProvider.setLevel(level);
        }
        ItemStack copied = stack.copy();
        EnchantmentHelper.updateEnchantments((ItemStack)copied, mutable -> ((EnchantmentProvider)((Holder.Reference)provider.get()).value()).enchant(copied, mutable, random, levelAccessor.getCurrentDifficultyAt(pos)));
        ItemEnchantments originalEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        ItemEnchantments newEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)copied);
        for (Object2IntMap.Entry entry : newEnchantments.entrySet()) {
            if (originalEnchantments.getLevel((Holder)entry.getKey()) >= entry.getIntValue()) continue;
            Holder<EnchantmentCategory> category = ((ItemEnchantmentCategories)copied.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).findFirstCategory((Holder<Enchantment>)((Holder)entry.getKey()));
            if (category != null) {
                list.add(new EnchantmentInstanceWithCategory((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue(), category));
                continue;
            }
            list.add(new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue()));
        }
        return list;
    }
}

