/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.world.level.ClipContext;

public class EnchiridionCodecs {
    public static final Codec<ClipContext.Block> BLOCK_RAYCAST_CONTEXT_CODEC = EnchiridionCodecs.enumCodec(ClipContext.Block.class);
    public static final Codec<ClipContext.Fluid> FLUID_RAYCAST_CONTEXT_CODEC = EnchiridionCodecs.enumCodec(ClipContext.Fluid.class);

    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> enumClass) {
        return Codec.STRING.flatXmap(s -> {
            for (Enum potential : (Enum[])enumClass.getEnumConstants()) {
                if (!potential.name().toLowerCase(Locale.ROOT).equals(s.toLowerCase(Locale.ROOT))) continue;
                return DataResult.success((Object)potential);
            }
            return DataResult.error(() -> "Could not find block clip context '" + s + "'. Must be one of [ " + Arrays.stream((Enum[])enumClass.getEnumConstants()).map(t -> t.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")) + " ].");
        }, e -> DataResult.success((Object)e.name()));
    }
}

