/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util.trades;

import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.enchantment.provider.EnchantFromTrade;
import house.greenhouse.enchiridion.mixin.Accessor_VillagerTradesEnchantBookForEmeralds;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class EnchiridionEnchantBookForEmeralds
extends VillagerTrades.EnchantBookForEmeralds {
    private final ResourceKey<EnchantmentProvider> providerKey;
    private final float priceModifier;
    private final float priceMultiplier;

    public EnchiridionEnchantBookForEmeralds(int villagerXp, ResourceKey<EnchantmentProvider> providerKey, float priceMultiplier) {
        this(villagerXp, providerKey, 1.0f, priceMultiplier);
    }

    public EnchiridionEnchantBookForEmeralds(int villagerXp, ResourceKey<EnchantmentProvider> providerKey, float priceModifier, float priceMultiplier) {
        super(villagerXp, EnchiridionTags.EnchantmentTags.LIBRARIAN_TRADES_PLAINS_COMMON);
        this.providerKey = providerKey;
        this.priceModifier = priceModifier;
        this.priceMultiplier = priceMultiplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MerchantOffer getOffer(Entity trader, @NotNull RandomSource random) {
        Object enchantFromTrade;
        int i = 0;
        ItemStack stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentProvider provider = (EnchantmentProvider)trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT_PROVIDER).get(this.providerKey);
        if (provider != null) {
            if (provider instanceof EnchantFromTrade) {
                enchantFromTrade = (EnchantFromTrade)provider;
                try {
                    boolean bl;
                    IntProvider intProvider = ((EnchantFromTrade)enchantFromTrade).amount();
                    HolderSet<Enchantment> amount = intProvider;
                    intProvider = ((EnchantFromTrade)enchantFromTrade).enchantments();
                    HolderSet<Enchantment> enchantments = intProvider;
                    intProvider = ((EnchantFromTrade)enchantFromTrade).categories();
                    Object categories = intProvider;
                    IntProvider level = intProvider = ((EnchantFromTrade)enchantFromTrade).level();
                    boolean allowDuplicateEnchantments = bl = ((EnchantFromTrade)enchantFromTrade).allowDuplicateEnchantments();
                    boolean allowDuplicateCategories = bl = ((EnchantFromTrade)enchantFromTrade).allowDuplicateCategories();
                    if (!allowDuplicateEnchantments || !allowDuplicateCategories) {
                        provider = new EnchantFromTrade((IntProvider)amount, (HolderSet<Enchantment>)HolderSet.direct(enchantments.stream().filter(holder -> allowDuplicateEnchantments || ((Merchant)trader).getOffers().stream().noneMatch(merchantOffer -> EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)merchantOffer.getResult()).keySet().contains(holder))).toList()), (HolderSet<EnchantmentCategory>)HolderSet.direct(categories.stream().filter(holder -> allowDuplicateCategories || ((Merchant)trader).getOffers().stream().noneMatch(merchantOffer -> ((ItemEnchantmentCategories)merchantOffer.getResult().getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).getCategories().containsKey(holder))).toList()), level, allowDuplicateEnchantments, allowDuplicateCategories);
                    }
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            EnchantmentProvider finalProvider = provider;
            ItemStack finalStack = stack;
            EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> finalProvider.enchant(finalStack, mutable, random, trader.level().getCurrentDifficultyAt(trader.blockPosition())));
        }
        if (EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty()) {
            stack = new ItemStack((ItemLike)Items.BOOK);
            i = 1;
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, i), Optional.of(new ItemCost((ItemLike)Items.BOOK)), stack, 8, ((Accessor_VillagerTradesEnchantBookForEmeralds)((Object)this)).enchiridion$getVillagerXp(), this.priceMultiplier);
        }
        enchantFromTrade = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().iterator();
        while (true) {
            if (!enchantFromTrade.hasNext()) {
                if (i <= 64) return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, i), Optional.of(new ItemCost((ItemLike)Items.BOOK)), stack, 8, ((Accessor_VillagerTradesEnchantBookForEmeralds)((Object)this)).enchiridion$getVillagerXp(), this.priceMultiplier);
                i = 64;
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, i), Optional.of(new ItemCost((ItemLike)Items.BOOK)), stack, 8, ((Accessor_VillagerTradesEnchantBookForEmeralds)((Object)this)).enchiridion$getVillagerXp(), this.priceMultiplier);
            }
            Map.Entry entry = (Map.Entry)enchantFromTrade.next();
            int addedAmount = 2 + random.nextInt(6 + (Integer)entry.getValue(), 6 + (Integer)entry.getValue() * 6) + 3;
            if (((Holder)entry.getKey()).is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                addedAmount = (int)((float)addedAmount * 1.4f);
            }
            addedAmount = (int)((float)addedAmount * this.priceModifier * (float)Math.max(1, (Integer)entry.getValue() / 2));
            i += addedAmount;
        }
    }
}

