/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record EnchantmentCategory(class_6885<class_1887> acceptedEnchantments, class_2561 name, Optional<class_2960> enchantedBookModelLocation, Optional<class_2960> fullEnchantedBookModelLocation, Optional<class_5251> color, Optional<Integer> limit, float tradeChance, int priority) {
    public static final Codec<class_6880<EnchantmentCategory>> CODEC = class_6899.method_40400(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final class_9139<class_9129, class_6880<EnchantmentCategory>> STREAM_CODEC = class_9135.method_56383(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final Codec<EnchantmentCategory> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_6895.method_40341((class_5321)class_7924.field_41265, (Codec)class_1887.field_51643).fieldOf("accepted_enchantments").forGetter(EnchantmentCategory::acceptedEnchantments), (App)class_8824.field_46597.fieldOf("name").forGetter(EnchantmentCategory::name), (App)class_2960.field_25139.optionalFieldOf("enchanted_book_model").forGetter(EnchantmentCategory::enchantedBookModelLocation), (App)class_5251.field_39242.optionalFieldOf("color").forGetter(EnchantmentCategory::color), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("limit").forGetter(EnchantmentCategory::limit), (App)Codec.FLOAT.optionalFieldOf("trade_chance", (Object)Float.valueOf(0.5f)).forGetter(EnchantmentCategory::tradeChance), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(EnchantmentCategory::priority)).apply((Applicative)inst, EnchantmentCategory::new));

    public EnchantmentCategory(class_6885<class_1887> acceptedEnchantments, class_2561 name, Optional<class_2960> enchantedBookModelLocation, Optional<class_5251> color, Optional<Integer> limit, float tradeChance, int priority) {
        this(acceptedEnchantments, name, enchantedBookModelLocation, enchantedBookModelLocation.map(resourceLocation -> resourceLocation.method_45134(string -> "item/enchiridion/" + string)), color, limit, tradeChance, priority);
    }

    public static Builder builder(class_6885<class_1887> acceptedEnchantments) {
        return new Builder(acceptedEnchantments);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EnchantmentCategory)) {
            return false;
        }
        EnchantmentCategory category = (EnchantmentCategory)obj;
        return category.acceptedEnchantments.equals(this.acceptedEnchantments) && category.name.equals((Object)this.name) && category.enchantedBookModelLocation.equals(this.enchantedBookModelLocation) && category.fullEnchantedBookModelLocation.equals(this.fullEnchantedBookModelLocation) && category.color.equals(this.color) && category.limit.equals(this.limit) && category.tradeChance == this.tradeChance && category.priority == this.priority;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acceptedEnchantments, this.name, this.enchantedBookModelLocation, this.fullEnchantedBookModelLocation, this.color, this.limit, Float.valueOf(this.tradeChance), this.priority);
    }

    public static class Builder {
        private final class_6885<class_1887> acceptedEnchantments;
        private Optional<class_5251> color = Optional.empty();
        private Optional<class_2960> enchantedBookModelLocation = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private float tradeChance = 0.5f;
        private int priority = 0;

        protected Builder(class_6885<class_1887> acceptedEnchantments) {
            this.acceptedEnchantments = acceptedEnchantments;
        }

        public Builder color(class_5251 color) {
            this.color = Optional.of(color);
            return this;
        }

        public Builder enchantedBookModelLocation(class_2960 modelLocation) {
            this.enchantedBookModelLocation = Optional.of(modelLocation);
            return this;
        }

        public Builder limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder tradeChance(float tradeChance) {
            this.tradeChance = tradeChance;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public EnchantmentCategory build(class_2960 id) {
            return new EnchantmentCategory(this.acceptedEnchantments, (class_2561)class_2561.method_43471((String)("enchiridion.category." + id.method_42094())), this.enchantedBookModelLocation, this.color, this.limit, this.tradeChance, this.priority);
        }
    }
}

