/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.block.entity;

import com.google.common.collect.Lists;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.registry.EnchiridionSoundEvents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class SiphoningTableBlockEntity
extends class_2624
implements class_3908,
class_1278,
class_1732,
class_1737 {
    public static final int MAXIMUM_EXPERIENCE = 15;
    private final class_2371<class_1799> items;
    private int enchantTime;
    private int enchantTimeTotal;
    private int experience;
    private boolean siphoning;
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeChecker quickCheck;
    public int time;
    public float bookY;
    public float oldBookY;
    public float flip;
    public float oldFlip;
    public float flipT;
    public float flipA;
    public float rot;
    public float oldRot;
    public float tRot;
    public float open = 1.5f;
    private static final class_5819 RANDOM = class_5819.method_43047();
    @Nullable
    private class_2561 name;

    public SiphoningTableBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchiridionBlockEntityTypes.SIPHONING_TABLE, pos, state);
        this.items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        this.quickCheck = new RecipeChecker();
    }

    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.items.set(i, (Object)(items.size() < i ? class_1799.field_8037 : (class_1799)items.get(i)));
        }
        this.method_5431();
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        tag.method_10569("enchant_time", this.enchantTime);
        tag.method_10569("enchant_time_total", this.enchantTimeTotal);
        tag.method_10569("xp", this.experience);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.items.clear();
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        this.enchantTime = tag.method_10550("enchant_time");
        this.enchantTimeTotal = tag.method_10550("enchant_time_total");
        this.experience = tag.method_10550("xp");
        this.siphoning = tag.method_10577("has_recipe");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = new class_2487();
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        tag.method_10569("xp", this.experience);
        tag.method_10556("has_recipe", this.siphoning);
        return tag;
    }

    public int getExperience() {
        return this.experience;
    }

    public void giveExperiencePoints(int xpPoints) {
        this.experience = Math.clamp((long)(this.experience + xpPoints), 0, 15);
        this.method_5431();
    }

    public int getEnchantTime() {
        return this.enchantTime;
    }

    public int getEnchantTimeTotal() {
        return this.enchantTimeTotal;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, SiphoningTableBlockEntity siphoningTable) {
        SiphoningInput input;
        Optional<class_8786<SiphoningRecipe>> optionalRecipe;
        boolean didInventoryChange = false;
        boolean shouldDrain = true;
        if (siphoningTable.hasInput() && (optionalRecipe = siphoningTable.quickCheck.getRecipeFor(input = new SiphoningInput((class_1263)siphoningTable), level)).isPresent()) {
            class_1799 newItem = ((SiphoningRecipe)optionalRecipe.get().comp_1933()).assemble(input, (class_7225.class_7874)level.method_30349()).method_7972();
            if (!class_1799.method_31577((class_1799)siphoningTable.method_5438(2), (class_1799)newItem) && (siphoningTable.isSiphoning() || siphoningTable.getExperience() >= ((SiphoningRecipe)optionalRecipe.get().comp_1933()).getExperienceCost()) && siphoningTable.canStackWithResultSlot(newItem)) {
                class_8786<SiphoningRecipe> recipe = optionalRecipe.get();
                didInventoryChange = siphoningTable.processEnchanting((SiphoningRecipe)recipe.comp_1933(), newItem);
                if (!siphoningTable.siphoning) {
                    siphoningTable.siphoning = true;
                    siphoningTable.method_5431();
                }
                shouldDrain = false;
            }
        }
        if (shouldDrain) {
            siphoningTable.enchantTime = Math.max(0, siphoningTable.enchantTime - 4);
            if (siphoningTable.siphoning) {
                siphoningTable.siphoning = false;
                siphoningTable.method_5431();
            }
        }
        if (didInventoryChange) {
            siphoningTable.method_5431();
        }
    }

    private boolean processEnchanting(SiphoningRecipe recipe, class_1799 assembled) {
        if (this.field_11863 == null) {
            return false;
        }
        ++this.enchantTime;
        this.enchantTimeTotal = recipe.getTime();
        if (this.enchantTime < this.enchantTimeTotal) {
            if ((this.enchantTimeTotal - this.enchantTime) % (this.enchantTimeTotal / recipe.getExperienceCost()) == 0) {
                --this.experience;
            }
            this.method_5431();
            return false;
        }
        this.enchantTime = 0;
        this.enchantTimeTotal = 0;
        for (int i = 0; i < 3; ++i) {
            int shrinkAmount = i == 2 ? 1 : recipe.getIngredientCosts().get(i);
            class_1799 stack = (class_1799)this.items.get(i);
            stack.method_7934(shrinkAmount);
            this.items.set(i, (Object)stack);
        }
        if (((class_1799)this.items.get(3)).method_7960()) {
            this.items.set(3, (Object)assembled);
        } else {
            ((class_1799)this.items.get(3)).method_7933(1);
        }
        this.field_11863.method_8396(null, this.method_11016(), EnchiridionSoundEvents.SIPHONING_TABLE_FINISH, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.8f);
        return true;
    }

    private boolean canStackWithResultSlot(class_1799 result) {
        class_1799 resultItem = (class_1799)this.items.get(3);
        return resultItem.method_7960() || class_1799.method_31577((class_1799)resultItem, (class_1799)result) && resultItem.method_7947() + result.method_7947() < resultItem.method_7914();
    }

    private boolean hasInput() {
        return !this.items.subList(0, 3).stream().filter(stack -> !stack.method_7960()).toList().isEmpty();
    }

    public boolean hasBook() {
        return this.method_5438(2).method_31574(class_1802.field_8529) || this.method_5438(2).method_31574(class_1802.field_8598) || this.method_5438(3).method_31574(class_1802.field_8598);
    }

    public static void bookAnimationTick(class_1937 level, class_2338 pos, class_2680 state, SiphoningTableBlockEntity siphoningTable) {
        float f2;
        if (!siphoningTable.hasBook() && siphoningTable.method_5438(2).method_7960() && siphoningTable.method_5438(3).method_7960()) {
            if (siphoningTable.time > 0) {
                siphoningTable.time = 0;
                siphoningTable.bookY = 0.0f;
                siphoningTable.oldBookY = 0.0f;
                siphoningTable.flip = 0.0f;
                siphoningTable.oldFlip = 0.0f;
                siphoningTable.flipT = 0.0f;
                siphoningTable.flipA = 0.0f;
                siphoningTable.rot = 0.0f;
                siphoningTable.oldRot = 0.0f;
                siphoningTable.tRot = 0.0f;
                siphoningTable.open = 1.5f;
            }
            return;
        }
        siphoningTable.oldRot = siphoningTable.rot;
        siphoningTable.oldBookY = siphoningTable.bookY;
        class_1657 player = level.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
        if (siphoningTable.isSiphoning()) {
            float bookYStart = 0.2f;
            if (siphoningTable.hasBook()) {
                if (player != null) {
                    double d0 = player.method_23317() - ((double)pos.method_10263() + 0.5);
                    double d1 = player.method_23321() - ((double)pos.method_10260() + 0.5);
                    siphoningTable.tRot = (float)class_3532.method_15349((double)d1, (double)d0);
                }
                if (RANDOM.method_43048(40) == 0) {
                    float f1 = siphoningTable.flipT;
                    do {
                        siphoningTable.flipT += (float)(RANDOM.method_43048(4) - RANDOM.method_43048(4));
                    } while (f1 == siphoningTable.flipT);
                }
                siphoningTable.open = Math.max(siphoningTable.open - 0.05f, 1.0f);
                bookYStart = 0.1f;
            }
            siphoningTable.bookY = bookYStart + class_3532.method_15374((float)((float)siphoningTable.time * bookYStart)) * 0.01f;
        } else {
            siphoningTable.tRot = 0.0f;
            siphoningTable.bookY = Math.max(siphoningTable.bookY - (siphoningTable.hasBook() ? 0.02f : 0.1f), 0.0f);
            siphoningTable.open = Math.min(siphoningTable.open + 0.05f, 1.2f);
        }
        while (siphoningTable.rot >= (float)Math.PI) {
            siphoningTable.rot -= (float)Math.PI * 2;
        }
        while (siphoningTable.rot < (float)(-Math.PI)) {
            siphoningTable.rot += (float)Math.PI * 2;
        }
        while (siphoningTable.tRot >= (float)Math.PI) {
            siphoningTable.tRot -= (float)Math.PI * 2;
        }
        while (siphoningTable.tRot < (float)(-Math.PI)) {
            siphoningTable.tRot += (float)Math.PI * 2;
        }
        for (f2 = siphoningTable.tRot - siphoningTable.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        siphoningTable.rot += f2 * 0.4f;
        ++siphoningTable.time;
        siphoningTable.oldFlip = siphoningTable.flip;
        float f = (siphoningTable.flipT - siphoningTable.flip) * 0.4f;
        f = class_3532.method_15363((float)f, (float)-0.2f, (float)0.2f);
        siphoningTable.flipA += (f - siphoningTable.flipA) * 0.9f;
        siphoningTable.flip += siphoningTable.flipA;
    }

    public boolean isSiphoning() {
        return this.siphoning;
    }

    public void awardUsedRecipes(class_3222 player) {
        List<class_8786<?>> list = this.getRecipesToAward(player.method_51469());
        player.method_7254(list);
        for (class_8786<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.method_51283(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<class_8786<?>> getRecipesToAward(class_3218 level) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(list::add);
        }
        return list;
    }

    public void setCustomName(@Nullable class_2561 customName) {
        this.name = customName;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.name;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.enchiridion.siphon");
    }

    public void method_57569(class_2487 tag) {
        tag.method_10551("CustomName");
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.comp_1932(), 1);
        }
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 stack : this.items) {
            contents.method_7400(stack);
        }
    }

    public int method_5439() {
        return 4;
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new SiphoningMenu(containerId, inventory, this);
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return new int[]{3};
        }
        if (direction.method_10166().method_10179()) {
            return new int[]{0, 1};
        }
        return new int[]{2};
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return index == 3;
        }
        if (direction.method_10166().method_10179()) {
            return index == 0 || index == 1;
        }
        return direction == class_2350.field_11036;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return index == 3;
        }
        if (direction.method_10166().method_10179()) {
            return index == 0 || index == 1;
        }
        return direction == class_2350.field_11036;
    }

    public void method_5431() {
        super.method_5431();
        if (!this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
        this.quickCheck.checkNewRecipe();
    }

    public static class RecipeChecker
    implements class_1863.class_7266<SiphoningInput, SiphoningRecipe> {
        @Nullable
        private class_2960 lastRecipe;
        private boolean checkNewRecipe = true;

        protected RecipeChecker() {
        }

        public Optional<class_8786<SiphoningRecipe>> getRecipeFor(SiphoningInput input, class_1937 level) {
            class_8786 recipeHolder;
            SiphoningRecipe siphoning;
            class_1860 class_18602;
            class_1863 recipeManager = level.method_8433();
            Optional lastOptional = recipeManager.method_8130(this.lastRecipe);
            if (!this.checkNewRecipe && lastOptional.isPresent() && (class_18602 = ((class_8786)lastOptional.get()).comp_1933()) instanceof SiphoningRecipe && (siphoning = (SiphoningRecipe)class_18602).matches(input, level)) {
                recipeHolder = (class_8786)lastOptional.get();
                return Optional.of(recipeHolder);
            }
            Optional<class_8786> optional = recipeManager.method_30027(EnchiridionRecipeTypes.SIPHONING).stream().filter(holder -> ((SiphoningRecipe)holder.comp_1933()).matches(input, level)).max(Comparator.comparingInt(value -> ((SiphoningRecipe)value.comp_1933()).getEnchantments().entrySet().stream().mapToInt(value1 -> ((class_9304)value1.getValue()).method_57539().stream().map(Object2IntMap.Entry::getIntValue).max(Comparator.comparingInt(value2 -> value2)).orElse(0)).max().orElse(0)));
            if (optional.isPresent()) {
                recipeHolder = optional.get();
                this.lastRecipe = recipeHolder.comp_1932();
                this.checkNewRecipe = false;
                return Optional.of(recipeHolder);
            }
            return Optional.empty();
        }

        protected void checkNewRecipe() {
            this.checkNewRecipe = true;
        }
    }
}

