/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.fabric;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionAttributes;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantments;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.command.CategoriseCommand;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.fabric.data.EnchiridionSkullMapRegistry;
import house.greenhouse.enchiridion.fabric.data.EnchiridionSplittingMapRegistry;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootPool;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootTableBuilder;
import house.greenhouse.enchiridion.fabric.platform.EnchiridionPlatformHelperFabric;
import house.greenhouse.enchiridion.fabric.util.TagUtil;
import house.greenhouse.enchiridion.fabric.util.VillagerTradeRemovalUtil;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantScrollIndexClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantedFrozenStateClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantmentLevelUpSeedsClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncItemUseDurationClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncSmashAttackSourceClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncSprintDirectionsClientboundPacket;
import house.greenhouse.enchiridion.network.serverbound.MissedAttackEnchantmentEffectClientboundEnchantment;
import house.greenhouse.enchiridion.network.serverbound.SyncCurrentSprintDirectionServerboundPacket;
import house.greenhouse.enchiridion.network.serverbound.SyncEnchantScrollIndexServerboundPacket;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionBlocks;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentProviderTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentValueEffectTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEntityEnchantmentEffectTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEntitySubPredicateTypes;
import house.greenhouse.enchiridion.registry.EnchiridionEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionItemSubPredicates;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.registry.EnchiridionLootItemConditions;
import house.greenhouse.enchiridion.registry.EnchiridionLootItemFunctions;
import house.greenhouse.enchiridion.registry.EnchiridionMenuTypes;
import house.greenhouse.enchiridion.registry.EnchiridionMobEffects;
import house.greenhouse.enchiridion.registry.EnchiridionParticleTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeSerializers;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.registry.EnchiridionSoundEvents;
import house.greenhouse.enchiridion.util.AnvilUtil;
import house.greenhouse.enchiridion.util.BCUtil;
import house.greenhouse.enchiridion.util.ClientRegistryAccessReference;
import house.greenhouse.enchiridion.util.CreativeTabUtil;
import house.greenhouse.enchiridion.util.EnchiridionUtil;
import house.greenhouse.enchiridion.util.VillagerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2168;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5455;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9356;
import net.minecraft.class_9360;
import net.minecraft.class_9361;
import net.minecraft.server.MinecraftServer;

public class EnchiridionFabric
implements ModInitializer {
    public static MinecraftServer server;
    private static class_3300 lootTableResourceManager;
    private static final class_2960 AFTER_PHASE;
    private static final Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> REMOVED_TRADES_SNAPSHOT;
    private static final Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT;

    public static void setLootTableResourceManager(class_3300 manager) {
        lootTableResourceManager = manager;
    }

    public void onInitialize() {
        Enchiridion.init(new EnchiridionPlatformHelperFabric());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(EnchiridionSkullMapRegistry.ReloadListener.ID, EnchiridionSkullMapRegistry.ReloadListener::new);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(EnchiridionSplittingMapRegistry.ReloadListener.ID, EnchiridionSplittingMapRegistry.ReloadListener::new);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> {
            CreativeTabUtil.addSiphoningTableToCreativeMenu((before, after, visibility) -> entries.addAfter(before, new class_1799[]{after}));
            entries.method_45421((class_1935)EnchiridionItems.ENCHIRIDION_ENCHANTING_TABLE);
            entries.method_45421((class_1935)EnchiridionItems.ENCHIRIDION_ANVIL);
        });
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((group, entries) -> {
            entries.getDisplayStacks().removeIf(stack -> stack.method_31574(class_1802.field_8598) && BCUtil.shouldRemoveFromSearchables(stack));
            entries.getSearchTabStacks().removeIf(stack -> stack.method_31574(class_1802.field_8598) && BCUtil.shouldRemoveFromSearchables(stack));
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> CategoriseCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        LootTableEvents.MODIFY.register((key, table, source, provider) -> {
            class_2960 location = key.method_29177();
            if (location.method_12832().startsWith("blocks/")) {
                Optional blockHolder = provider.method_46762(class_7924.field_41254).method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)location.method_45134(string -> string.split("/", 2)[1])));
                Optional enchantmentHolder = provider.method_46762(class_7924.field_41265).method_46746(EnchiridionEnchantments.CRUMBLE);
                if (enchantmentHolder.isPresent() && blockHolder.isPresent() && TagUtil.isInBaseStoneTag((class_6880<class_2248>)((class_6880)blockHolder.get()), lootTableResourceManager, (class_7225<class_2248>)class_7923.field_41175.method_46771())) {
                    List<class_55> pools = ((Accessor_LootTableBuilder)table).enchiridion$getPools().build().stream().peek(pool -> {
                        ArrayList<class_5341> conditions = new ArrayList<class_5341>(pool.field_954);
                        class_2035 predicate = new class_2035((class_6880)enchantmentHolder.get(), class_2096.class_2100.method_9053((int)1));
                        conditions.add(class_207.method_889((class_5341.class_210)class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_58179(class_9361.field_49807, (class_9360)class_9356.method_58173(List.of(predicate))))).build());
                        ((Accessor_LootPool)pool).enchiridion$setConditions((List<class_5341>)ImmutableList.copyOf(conditions));
                        ((Accessor_LootPool)pool).enchiridion$setCompositeCondition(class_156.method_56613(conditions));
                    }).toList();
                    ImmutableList.Builder poolBuilder = ImmutableList.builder();
                    poolBuilder.addAll(pools);
                    ((Accessor_LootTableBuilder)table).enchiridion$setPools((ImmutableList.Builder<class_55>)poolBuilder);
                }
            }
        });
        EnchiridionFabric.registerContents();
        EnchiridionFabric.registerPackets();
        ServerLifecycleEvents.SERVER_STARTING.addPhaseOrdering(Event.DEFAULT_PHASE, AFTER_PHASE);
        ServerLifecycleEvents.SERVER_STARTING.register(AFTER_PHASE, server1 -> {
            server = server1;
            EnchiridionFabric.registerVillagerTrades();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server1 -> {
            server = null;
        });
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)target.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            class_6880<EnchantmentCategory> category = EnchiridionUtil.getFirstEnchantmentCategory((class_7225.class_7874)EnchiridionFabric.getRegistryAccess(), (class_6880<class_1887>)enchantment);
            if (category != null && !AnvilUtil.getAnvilContext() && !EnchiridionUtil.categoryAcceptsNewEnchantmentsWithValue(category, categories, (class_6880<class_1887>)enchantment)) {
                return TriState.FALSE;
            }
            return TriState.DEFAULT;
        });
        DefaultItemComponentEvents.MODIFY.register(context -> context.modify(class_1802.field_8598, builder -> builder.method_57840(class_9334.field_50071, (Object)16)));
        FabricLoader.getInstance().getModContainer("enchiridion").ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Enchiridion.asResource("default_enchanted_books"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"resourcePack.enchiridion.default_enchanted_books.name"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            if (Enchiridion.ENCHANTMENT_DESCRIPTION_MODS.stream().anyMatch(s -> FabricLoader.getInstance().isModLoaded(s))) {
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Enchiridion.asResource("enchantment_descriptions_compat"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"resourcePack.enchiridion.enchantment_descriptions_compat.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
            }
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Enchiridion.asResource("vanilla_enchantment_modifications"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"dataPack.enchiridion.vanilla_enchantment_modifications.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Enchiridion.asResource("vanilla_balancing"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"dataPack.enchiridion.vanilla_balancing.name"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
    }

    public static void registerPackets() {
        PayloadTypeRegistry.playS2C().register(SyncEnchantScrollIndexClientboundPacket.TYPE, SyncEnchantScrollIndexClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncEnchantedFrozenStateClientboundPacket.TYPE, SyncEnchantedFrozenStateClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncEnchantmentLevelUpSeedsClientboundPacket.TYPE, SyncEnchantmentLevelUpSeedsClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncItemUseDurationClientboundPacket.TYPE, SyncItemUseDurationClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncSmashAttackSourceClientboundPacket.TYPE, SyncSmashAttackSourceClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncSprintDirectionsClientboundPacket.TYPE, SyncSprintDirectionsClientboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(MissedAttackEnchantmentEffectClientboundEnchantment.TYPE, MissedAttackEnchantmentEffectClientboundEnchantment.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(SyncCurrentSprintDirectionServerboundPacket.TYPE, SyncCurrentSprintDirectionServerboundPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(SyncEnchantScrollIndexServerboundPacket.TYPE, SyncEnchantScrollIndexServerboundPacket.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(MissedAttackEnchantmentEffectClientboundEnchantment.TYPE, (payload, context) -> payload.handle(context.player()));
        ServerPlayNetworking.registerGlobalReceiver(SyncCurrentSprintDirectionServerboundPacket.TYPE, (payload, context) -> payload.handle(context.player()));
        ServerPlayNetworking.registerGlobalReceiver(SyncEnchantScrollIndexServerboundPacket.TYPE, (payload, context) -> payload.handle(context.player()));
    }

    public static void registerContents() {
        EnchiridionAttributes.registerAll();
        EnchiridionBlocks.registerAll();
        EnchiridionBlockEntityTypes.registerAll();
        EnchiridionDataComponents.registerAll();
        EnchiridionEnchantmentEffectComponents.registerAll();
        EnchiridionEnchantmentProviderTypes.registerAll();
        EnchiridionEnchantmentValueEffectTypes.registerAll();
        EnchiridionEntityEnchantmentEffectTypes.registerAll();
        EnchiridionEntitySubPredicateTypes.registerAll();
        EnchiridionEntityTypes.registerAll();
        EnchiridionItems.registerAll();
        EnchiridionItemSubPredicates.registerAll();
        EnchiridionLootItemConditions.registerAll();
        EnchiridionLootItemFunctions.registerAll();
        EnchiridionMenuTypes.registerAll();
        EnchiridionMobEffects.registerAll();
        EnchiridionParticleTypes.registerAll();
        EnchiridionRecipeSerializers.registerAll();
        EnchiridionRecipeTypes.registerAll();
        EnchiridionSoundEvents.registerAll();
        class_2591.field_11912.addSupportedBlock((class_2248)EnchiridionBlocks.ENCHIRIDION_ENCHANTING_TABLE);
        DynamicRegistries.registerSynced(EnchiridionRegistries.ENCHANTMENT_CATEGORY, EnchantmentCategory.DIRECT_CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
    }

    public static void registerVillagerTrades() {
        if (!REMOVED_TRADES_SNAPSHOT.isEmpty()) {
            for (Map.Entry<class_3852, Int2ObjectMap<class_3853.class_1652[]>> entry : REMOVED_TRADES_SNAPSHOT.entrySet()) {
                for (Int2ObjectMap.Entry innerEntry : entry.getValue().int2ObjectEntrySet()) {
                    TradeOfferHelper.registerVillagerOffers((class_3852)entry.getKey(), (int)innerEntry.getIntKey(), (factories, rebalanced) -> {
                        if (!rebalanced) {
                            factories.addAll(Arrays.stream((class_3853.class_1652[])innerEntry.getValue()).toList());
                        }
                    });
                }
            }
            REMOVED_TRADES_SNAPSHOT.clear();
        }
        if (!REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT.isEmpty()) {
            for (Map.Entry<class_3852, Int2ObjectMap<class_3853.class_1652[]>> entry : REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT.entrySet()) {
                for (Int2ObjectMap.Entry innerEntry : entry.getValue().int2ObjectEntrySet()) {
                    TradeOfferHelper.registerVillagerOffers((class_3852)entry.getKey(), (int)innerEntry.getIntKey(), (factories, rebalanced) -> {
                        if (rebalanced) {
                            factories.addAll(Arrays.stream((class_3853.class_1652[])innerEntry.getValue()).toList());
                        }
                    });
                }
            }
            REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT.clear();
        }
        if (VillagerUtil.areEnchiridionVillagerTradesEnabled()) {
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17060, (int)1, VillagerUtil::modifyNoviceLibrarianTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17060, (int)2, VillagerUtil::modifyApprenticeLibrarianTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17060, (int)3, VillagerUtil::modifyJourneymanLibrarianTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17060, (int)4, VillagerUtil::modifyExpertLibrarianTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17060, (int)5, VillagerUtil::modifyMasterLibrarianTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)4, VillagerUtil::modifyExpertArmorerTradeOffers);
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)5, VillagerUtil::modifyMasterArmorerTradeOffers);
        }
        if (VillagerUtil.areEnchiridionVillagerTradesEnabled()) {
            HashMap<class_3852, Int2ObjectMap> trades = new HashMap<class_3852, Int2ObjectMap>(class_3853.field_17067);
            trades.computeIfPresent(class_3852.field_17060, (profession, objectMap) -> {
                Pair<Int2ObjectMap<class_3853.class_1652[]>, Int2ObjectMap<class_3853.class_1652[]>> newTradesAndRemoved = VillagerTradeRemovalUtil.removeExistingTrades((Int2ObjectMap<class_3853.class_1652[]>)objectMap, false, 1, 5, VillagerUtil::removeLibrarianEnchantmentTrades);
                REMOVED_TRADES_SNAPSHOT.put(class_3852.field_17060, (Int2ObjectMap<class_3853.class_1652[]>)((Int2ObjectMap)newTradesAndRemoved.getSecond()));
                return (Int2ObjectMap)newTradesAndRemoved.getFirst();
            });
            trades.computeIfPresent(class_3852.field_17052, (profession, objectMap) -> {
                Pair<Int2ObjectMap<class_3853.class_1652[]>, Int2ObjectMap<class_3853.class_1652[]>> newTradesAndRemoved = VillagerTradeRemovalUtil.removeExistingTrades((Int2ObjectMap<class_3853.class_1652[]>)objectMap, false, 4, 5, VillagerUtil::removeArmorerEnchantmentTrades);
                REMOVED_TRADES_SNAPSHOT.put(class_3852.field_17060, (Int2ObjectMap<class_3853.class_1652[]>)((Int2ObjectMap)newTradesAndRemoved.getSecond()));
                return (Int2ObjectMap)newTradesAndRemoved.getFirst();
            });
            class_3853.field_17067 = trades;
            HashMap<class_3852, Int2ObjectMap> experimentalTrades = new HashMap<class_3852, Int2ObjectMap>(class_3853.field_45128);
            experimentalTrades.computeIfPresent(class_3852.field_17060, (profession, objectMap) -> {
                Pair<Int2ObjectMap<class_3853.class_1652[]>, Int2ObjectMap<class_3853.class_1652[]>> newTradesAndRemoved = VillagerTradeRemovalUtil.removeExistingTrades((Int2ObjectMap<class_3853.class_1652[]>)objectMap, true, 1, 5, VillagerUtil::removeLibrarianEnchantmentTrades);
                REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT.put(class_3852.field_17060, (Int2ObjectMap<class_3853.class_1652[]>)((Int2ObjectMap)newTradesAndRemoved.getSecond()));
                return (Int2ObjectMap)newTradesAndRemoved.getFirst();
            });
            experimentalTrades.computeIfPresent(class_3852.field_17052, (profession, objectMap) -> {
                Pair<Int2ObjectMap<class_3853.class_1652[]>, Int2ObjectMap<class_3853.class_1652[]>> newTradesAndRemoved = VillagerTradeRemovalUtil.removeExistingTrades((Int2ObjectMap<class_3853.class_1652[]>)objectMap, true, 4, 5, VillagerUtil::removeArmorerEnchantmentTrades);
                REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT.put(class_3852.field_17060, (Int2ObjectMap<class_3853.class_1652[]>)((Int2ObjectMap)newTradesAndRemoved.getSecond()));
                return (Int2ObjectMap)newTradesAndRemoved.getFirst();
            });
            class_3853.field_45128 = experimentalTrades;
        }
    }

    public static class_5455 getRegistryAccess() {
        if (server == null || !server.method_3816()) {
            return ClientRegistryAccessReference.get(server);
        }
        return server.method_30611();
    }

    static {
        AFTER_PHASE = Enchiridion.asResource("after");
        REMOVED_TRADES_SNAPSHOT = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>();
        REMOVED_EXPERIMENTAL_TRADES_SNAPSHOT = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>();
    }
}

