/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.fabric.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import house.greenhouse.enchiridion.Enchiridion;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class EnchiridionSplittingMapRegistry {
    private static Map<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799> MAP = ImmutableMap.of();

    @Nullable
    public static class_1799 getSplittingItem(class_6880<class_1792> item) {
        return MAP.entrySet().stream().filter(entry -> (Boolean)((Either)entry.getKey()).map(arg_0 -> ((class_6880)item).method_40220(arg_0), arg_0 -> ((class_6880)item).method_55838(arg_0))).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static class ReloadListener
    extends class_4080<Map<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799>>
    implements IdentifiableResourceReloadListener {
        public static final class_2960 ID = Enchiridion.asResource("splitting");
        private final class_7225.class_7874 provider;

        public ReloadListener(class_7225.class_7874 provider) {
            this.provider = provider;
        }

        protected Map<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
            HashMap<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799> map = new HashMap<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799>();
            for (class_3298 resource : resourceManager.method_14489(ID.method_45134(string -> string + ".json"))) {
                try {
                    DataResult condition;
                    JsonElement json = JsonParser.parseReader((Reader)resource.method_43039());
                    if (!json.isJsonObject()) {
                        Enchiridion.LOGGER.error("enchiridion:splitting.json in pack {} is not a json object", (Object)resource.method_14480());
                        continue;
                    }
                    JsonObject jsonObject = json.getAsJsonObject();
                    if (jsonObject.has("fabric:load_conditions") && !((ResourceCondition)(condition = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("fabric:load_conditions"))).getOrThrow()).test(this.provider)) continue;
                    if (!jsonObject.has("values")) {
                        Enchiridion.LOGGER.error("enchiridion:splitting.json in pack {} does not have a values field.", (Object)resource.method_14480());
                        continue;
                    }
                    if (jsonObject.has("replace") && jsonObject.get("replace").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("replace").getAsBoolean()) {
                        map.clear();
                    }
                    for (Map.Entry entry : jsonObject.getAsJsonObject("values").asMap().entrySet()) {
                        this.readIntoMap(map, (String)entry.getKey(), (JsonElement)entry.getValue(), resource.method_14480());
                    }
                }
                catch (IOException e) {
                    Enchiridion.LOGGER.error("Exception loading enchiridion:splitting.json in pack {}", (Object)resource.method_14480());
                }
            }
            return map;
        }

        private void readIntoMap(Map<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799> map, String key, JsonElement value, String sourcePackId) {
            Either either;
            if (key.startsWith("#")) {
                either = Either.left((Object)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)key.substring(1))));
            } else {
                Optional item = class_7923.field_41178.method_55841(class_2960.method_60654((String)key));
                if (item.isEmpty()) {
                    Enchiridion.LOGGER.error("Could not find item with id '{}'. Sourced from enchiridion:splitting.json in pack {}", (Object)key, (Object)sourcePackId);
                    return;
                }
                either = Either.right((Object)((class_6880)item.get()));
            }
            DataResult stack = class_1799.field_51398.decode((DynamicOps)JsonOps.INSTANCE, (Object)value);
            if (stack.isError()) {
                Enchiridion.LOGGER.error("Failed to decode splitting item stack of item '{}'. Sourced from enchiridion:splitting.json in pack {}. {}", new Object[]{key, sourcePackId, ((DataResult.Error)stack.error().orElseThrow()).message()});
                if (!stack.hasResultOrPartial()) {
                    return;
                }
            }
            map.put((Either<class_6862<class_1792>, class_6880<class_1792>>)either, (class_1799)((Pair)stack.getPartialOrThrow()).getFirst());
        }

        protected void apply(Map<Either<class_6862<class_1792>, class_6880<class_1792>>, class_1799> object, class_3300 resourceManager, class_3695 profilerFiller) {
            MAP = ImmutableMap.copyOf(object);
        }

        public class_2960 getFabricId() {
            return ID;
        }
    }
}

