/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.fabric.platform;

import house.greenhouse.enchiridion.api.enchantment.effects.DirectionalSprintEffect;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import house.greenhouse.enchiridion.fabric.EnchiridionFabric;
import house.greenhouse.enchiridion.fabric.block.SiphoningTableBlockEntityFabric;
import house.greenhouse.enchiridion.fabric.data.EnchiridionSkullMapRegistry;
import house.greenhouse.enchiridion.fabric.data.EnchiridionSplittingMapRegistry;
import house.greenhouse.enchiridion.fabric.mixin.client.Accessor_Minecraft;
import house.greenhouse.enchiridion.fabric.registry.EnchiridionAttachments;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantedFrozenStateClientboundPacket;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantmentLevelUpSeedsClientboundPacket;
import house.greenhouse.enchiridion.platform.EnchiridionPlatformHelper;
import house.greenhouse.enchiridion.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class EnchiridionPlatformHelperFabric
implements EnchiridionPlatformHelper {
    @Override
    public Platform getPlatform() {
        return Platform.FABRIC;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public class_5455 getReqistryAccess() {
        return EnchiridionFabric.getRegistryAccess();
    }

    @Override
    public class_9304 getEnchantments(class_7225.class_7226<class_1887> enchantments, class_1799 stack) {
        return stack.method_58657();
    }

    @Override
    public class_2591.class_5559<SiphoningTableBlockEntity> supplyBlockEntity() {
        return SiphoningTableBlockEntityFabric::new;
    }

    @Override
    public void openMenu(class_1657 player, SiphoningTableBlockEntity blockEntity, class_2338 pos) {
        player.method_17355((class_3908)blockEntity);
    }

    @Override
    public class_3917<SiphoningMenu> createMenuType() {
        return new ExtendedScreenHandlerType(SiphoningMenu::new, class_2338.field_48404);
    }

    @Override
    public Collection<class_3222> getTracking(class_1297 entity) {
        return PlayerLookup.tracking((class_1297)entity);
    }

    @Override
    public void sendClientbound(class_3222 player, class_8710 payload) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    @Override
    public void sendClientboundTracking(class_1297 entity, class_8710 payload) {
        for (class_3222 player : this.getTracking(entity)) {
            this.sendClientbound(player, payload);
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.sendClientbound(player, payload);
        }
    }

    @Override
    public void sendServerbound(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }

    @Override
    public void setFrozenByEnchantment(class_1297 entity, boolean value) {
        if (!value) {
            entity.removeAttached(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT);
        } else {
            entity.setAttached(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT, (Object)true);
        }
        if (!entity.method_37908().method_8608()) {
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncEnchantedFrozenStateClientboundPacket(entity.method_5628(), value));
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncEnchantedFrozenStateClientboundPacket(entity.method_5628(), value));
            }
        }
    }

    @Override
    public int getAirTime(class_1297 entity) {
        return (Integer)entity.getAttachedOrElse(EnchiridionAttachments.AIR_TIME, (Object)-1);
    }

    @Override
    public void setAirTime(class_1297 entity, int value) {
        if (value == -1) {
            entity.removeAttached(EnchiridionAttachments.CLIMB_TIME);
            return;
        }
        entity.setAttached(EnchiridionAttachments.AIR_TIME, (Object)value);
    }

    @Override
    public int getClimbTime(class_1297 entity) {
        return (Integer)entity.getAttachedOrElse(EnchiridionAttachments.CLIMB_TIME, (Object)-1);
    }

    @Override
    public void setClimbTime(class_1297 entity, int value) {
        if (value == -1) {
            entity.removeAttached(EnchiridionAttachments.CLIMB_TIME);
            return;
        }
        entity.setAttached(EnchiridionAttachments.CLIMB_TIME, (Object)value);
    }

    @Override
    public float getScopedValue(class_1297 entity) {
        return ((Float)entity.getAttachedOrElse(EnchiridionAttachments.SCOPED, (Object)Float.valueOf(0.0f))).floatValue();
    }

    @Override
    public void setScopedValue(class_1297 entity, float value) {
        entity.setAttached(EnchiridionAttachments.SCOPED, (Object)Float.valueOf(value));
    }

    @Override
    public void clearScopedValue(class_1297 entity) {
        entity.removeAttached(EnchiridionAttachments.SCOPED);
    }

    @Override
    public boolean containsEnchantmentSeed(class_1657 player, int index) {
        return ((List)player.getAttachedOrElse(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS, List.of())).size() < index;
    }

    @Override
    public int getEnchantmentSeed(class_1657 player, int index) {
        return Optional.ofNullable((List)player.getAttached(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS)).map(integers -> (Integer)integers.get(index)).orElse(-1);
    }

    @Override
    public void addEnchantmentSeed(class_1657 player, int index, int seed) {
        ((List)player.getAttachedOrCreate(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS, ArrayList::new)).add(index, seed);
        if (!player.method_37908().method_8608()) {
            for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)SyncEnchantmentLevelUpSeedsClientboundPacket.add(player.method_5628(), index, seed));
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)SyncEnchantmentLevelUpSeedsClientboundPacket.add(player.method_5628(), index, seed));
            }
        }
    }

    @Override
    public void clearEnchantmentSeeds(class_1657 player) {
        player.removeAttached(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS);
        if (!player.method_37908().method_8608()) {
            for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)SyncEnchantmentLevelUpSeedsClientboundPacket.clear(player.method_5628()));
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)SyncEnchantmentLevelUpSeedsClientboundPacket.clear(player.method_5628()));
            }
        }
    }

    @Override
    public boolean isFrozenByEnchantment(class_1297 entity) {
        return (Boolean)entity.getAttachedOrElse(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT, (Object)false);
    }

    @Override
    public boolean hasSprintDirectionAttachment(class_1297 entity) {
        return entity.hasAttached(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS);
    }

    @Override
    public void setAbleToSprintInDirection(class_1297 entity, List<class_2350> directions) {
        entity.setAttached(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS, directions);
    }

    @Override
    public void removeSprintDirections(class_1297 entity) {
        entity.removeAttached(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS);
    }

    @Override
    public boolean canSprintInDirection(class_1297 entity, class_2350 direction) {
        return ((List)entity.getAttachedOrElse(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS, DirectionalSprintEffect.DEFAULT)).contains(direction);
    }

    @Override
    public class_2350 getCurrentSprintingDirection(class_1297 entity) {
        return (class_2350)entity.getAttached(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION);
    }

    @Override
    public boolean hasCurrentSprintingDirection(class_1297 entity) {
        return entity.hasAttached(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION);
    }

    @Override
    public void setCurrentSprintingDirection(class_1297 entity, class_2350 direction) {
        if (direction == null) {
            entity.removeAttached(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION);
            return;
        }
        entity.setAttached(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION, (Object)direction);
    }

    @Override
    public UUID getPreviousAttackTarget(class_1297 entity) {
        return (UUID)entity.getAttached(EnchiridionAttachments.PREVIOUS_ATTACK_TARGET);
    }

    @Override
    public void setPreviousAttacKTarget(class_1297 entity, class_1297 target) {
        entity.setAttached(EnchiridionAttachments.PREVIOUS_ATTACK_TARGET, (Object)target.method_5667());
    }

    @Override
    public boolean isClient() {
        return Thread.currentThread() == ((Accessor_Minecraft)class_310.method_1551()).enchiridion$getGameThread();
    }

    @Override
    public boolean isPrimaryItem(class_1799 stack, class_6880<class_1887> enchantment) {
        return stack.canBeEnchantedWith(enchantment, EnchantingContext.PRIMARY);
    }

    @Override
    public boolean supportsEnchantment(class_1799 stack, class_6880<class_1887> enchantment) {
        return stack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE);
    }

    @Override
    @Nullable
    public class_1799 getItemForSplittingEnchantment(class_6880<class_1792> item) {
        return EnchiridionSplittingMapRegistry.getSplittingItem(item);
    }

    @Override
    @Nullable
    public class_5321<class_52> getSkullLootTableForEntity(class_6880<class_1299<?>> entityType) {
        return EnchiridionSkullMapRegistry.getLootTable(entityType);
    }
}

