/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.recipe;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.util.BCUtil;
import house.greenhouse.enchiridion.util.SiphoningBookCategory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SiphoningRecipe
implements class_1860<SiphoningInput> {
    private final String group;
    private final SiphoningBookCategory category;
    private final class_2371<class_1856> ingredients;
    private final IntList ingredientCosts;
    private final Map<class_6880<EnchantmentCategory>, class_9304> enchantments;
    private final int experienceCost;
    private final int time;
    private List<IngredientWithAmount> ingredientsWithAmounts;

    public SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, List<IngredientWithAmount> ingredients, Map<class_6880<EnchantmentCategory>, class_9304> enchantments, int experienceCost, int time) {
        this(group, category, SiphoningRecipe.createIngredientList(ingredients), SiphoningRecipe.createAmountList(ingredients), enchantments, experienceCost, time);
    }

    protected SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, List<class_1856> ingredients, List<Integer> ingredientCosts, Map<class_6880<EnchantmentCategory>, class_9304> enchantments, int experienceCost, int time) {
        this(group, category, SiphoningRecipe.transformIngredientList(ingredients), (IntList)new IntArrayList(ingredientCosts), enchantments, experienceCost, time);
    }

    protected SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, class_2371<class_1856> ingredients, IntList ingredientCosts, Map<class_6880<EnchantmentCategory>, class_9304> enchantments, int experienceCost, int time) {
        if (ingredients.size() > 2 || ingredientCosts.size() > 2) {
            throw new IllegalArgumentException("SiphoningRecipe does not support more than two ingredients.");
        }
        if (ingredients.size() != ingredientCosts.size()) {
            throw new IllegalArgumentException("SiphoningRecipe's ingredient and cost list are not the same size.");
        }
        this.group = group;
        this.category = category;
        this.ingredients = ingredients;
        this.ingredientCosts = ingredientCosts;
        this.experienceCost = experienceCost;
        this.enchantments = enchantments;
        this.time = time;
    }

    public String method_8112() {
        return this.group;
    }

    public SiphoningBookCategory getCategory() {
        return this.category;
    }

    public static class_2371<class_1856> createIngredientList(List<IngredientWithAmount> ingredients) {
        class_2371 list = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
        for (int i = 0; i < ingredients.size(); ++i) {
            list.set(i, (Object)ingredients.get(i).ingredient());
        }
        return list;
    }

    public static class_2371<class_1856> transformIngredientList(List<class_1856> ingredients) {
        class_2371 list = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
        for (int i = 0; i < ingredients.size(); ++i) {
            list.set(i, (Object)ingredients.get(i));
        }
        return list;
    }

    public static IntList createAmountList(List<IngredientWithAmount> ingredients) {
        return new IntArrayList(ingredients.stream().map(IngredientWithAmount::amount).toList());
    }

    public List<IngredientWithAmount> getIngredientsWithAmounts() {
        if (this.ingredientsWithAmounts == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < Math.min(this.ingredients.size(), this.ingredientCosts.size()); ++i) {
                builder.add((Object)new IngredientWithAmount((class_1856)this.ingredients.get(i), this.ingredientCosts.getInt(i)));
            }
            this.ingredientsWithAmounts = builder.build();
        }
        return this.ingredientsWithAmounts;
    }

    public boolean matches(SiphoningInput input, class_1937 level) {
        class_1799 ingredientOne = input.method_59984(0);
        class_1799 ingredientTwo = input.method_59984(1);
        class_1799 enchantable = input.method_59984(2);
        if (ingredientOne.method_7947() < (Integer)this.ingredientCosts.getFirst() || !((class_1856)this.ingredients.getFirst()).method_8093(ingredientOne)) {
            return false;
        }
        if (ingredientTwo.method_7947() < (Integer)this.ingredientCosts.getLast() || !((class_1856)this.ingredients.getLast()).method_8093(ingredientTwo)) {
            return false;
        }
        if (enchantable.method_31573(EnchiridionTags.ItemTags.STORED_ENCHANTABLES)) {
            return true;
        }
        List supportedItems = this.getEnchantments().entrySet().stream().flatMap(entry -> ((class_9304)entry.getValue()).method_57539().stream().flatMap(entry1 -> ((class_1887)((class_6880)entry1.getKey()).comp_349()).method_56109().method_40239().filter(itemHolder -> this.getEnchantments().values().stream().allMatch(enchantments -> enchantments.method_57534().stream().allMatch(enchantment -> ((class_1887)enchantment.comp_349()).method_60046(((class_1792)itemHolder.comp_349()).method_7854())))))).toList();
        if (supportedItems.isEmpty()) {
            return false;
        }
        return this.getEnchantments().entrySet().stream().allMatch(entry -> {
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)enchantable.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            if (((class_9304)entry.getValue()).method_57534().size() + categories.get((class_6880<EnchantmentCategory>)((class_6880)entry.getKey())).size() < ((EnchantmentCategory)((class_6880)entry.getKey()).comp_349()).limit().orElse(Integer.MIN_VALUE)) {
                return false;
            }
            return ((class_9304)entry.getValue()).method_57539().stream().allMatch(entry1 -> ((class_1887)((class_6880)entry1.getKey()).comp_349()).method_60046(enchantable));
        }) && supportedItems.contains(enchantable.method_41409());
    }

    public class_1799 assemble(SiphoningInput input, class_7225.class_7874 registries) {
        class_1799 stack = input.method_59984(2).method_31574(class_1802.field_8529) ? new class_1799((class_6880)class_1802.field_8598.method_40131(), input.method_59984(2).method_7947(), input.method_59984(2).method_57380()) : input.method_59984(2).method_7972();
        return this.assemble(stack.method_46651(1), registries);
    }

    public class_1799 assemble(class_1799 stack, class_7225.class_7874 registries) {
        ItemEnchantmentCategories itemEnchantmentCategories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)new ItemEnchantmentCategories());
        if (this.enchantments.values().stream().anyMatch(holder -> holder.method_57539().stream().anyMatch(entry -> !Enchiridion.getHelper().supportsEnchantment(stack, (class_6880<class_1887>)((class_6880)entry.getKey()))))) {
            return stack;
        }
        class_1890.method_57531((class_1799)stack, mutable -> {
            for (Map.Entry<class_6880<EnchantmentCategory>, class_9304> entry : this.enchantments.entrySet()) {
                for (Object2IntMap.Entry enchantment : entry.getValue().method_57539()) {
                    if (!((class_6880)enchantment.getKey()).method_40227() || !itemEnchantmentCategories.isValid(entry.getKey(), (class_6880<class_1887>)((class_6880)enchantment.getKey())) || !((class_1887)((class_6880)enchantment.getKey()).comp_349()).method_60046(stack) && Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack) != class_9334.field_49643) {
                        return;
                    }
                    itemEnchantmentCategories.add(entry.getKey(), (class_6880<class_1887>)((class_6880)enchantment.getKey()));
                    mutable.method_57550((class_6880)enchantment.getKey(), enchantment.getIntValue());
                }
            }
        });
        stack.method_57379(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)itemEnchantmentCategories);
        BCUtil.convertVanillaEnchantments(stack, (class_7225<class_1887>)registries.method_46762(class_7924.field_41265));
        return stack;
    }

    public boolean method_8113(int width, int height) {
        return width * height > this.ingredients.size();
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8598);
        ItemEnchantmentCategories itemEnchantmentCategories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)new ItemEnchantmentCategories());
        class_1890.method_57531((class_1799)stack, mutable -> {
            for (Map.Entry<class_6880<EnchantmentCategory>, class_9304> entry : this.enchantments.entrySet()) {
                for (Object2IntMap.Entry enchantment : entry.getValue().method_57539()) {
                    if (!((class_6880)enchantment.getKey()).method_40227() || !itemEnchantmentCategories.isValid(entry.getKey(), (class_6880<class_1887>)((class_6880)enchantment.getKey()))) {
                        return;
                    }
                    itemEnchantmentCategories.add(entry.getKey(), (class_6880<class_1887>)((class_6880)enchantment.getKey()));
                    mutable.method_57550((class_6880)enchantment.getKey(), enchantment.getIntValue());
                }
            }
        });
        stack.method_57379(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)itemEnchantmentCategories);
        BCUtil.convertVanillaEnchantments(stack, (class_7225<class_1887>)registries.method_46762(class_7924.field_41265));
        return stack;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public List<Integer> getIngredientCosts() {
        return this.ingredientCosts;
    }

    public Map<class_6880<EnchantmentCategory>, class_9304> getEnchantments() {
        return this.enchantments;
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    public int getTime() {
        return this.time;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return EnchiridionRecipeTypes.SIPHONING;
    }

    public record IngredientWithAmount(class_1856 ingredient, int amount) {
        public static final Codec<IngredientWithAmount> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1856.field_46096.fieldOf("ingredient").forGetter(IngredientWithAmount::ingredient), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(IngredientWithAmount::amount)).apply((Applicative)inst, IngredientWithAmount::new));
        public static final Codec<IngredientWithAmount> CODEC = Codec.withAlternative(DIRECT_CODEC, (Codec)class_1856.field_46096, in -> new IngredientWithAmount((class_1856)in, 1));
        public static final class_9139<class_9129, IngredientWithAmount> STREAM_CODEC = class_9139.method_56435((class_9139)class_1856.field_48355, IngredientWithAmount::ingredient, (class_9139)class_9135.field_49675, IngredientWithAmount::amount, IngredientWithAmount::new);
    }

    public static class Serializer
    implements class_1865<SiphoningRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<SiphoningRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SiphoningRecipe::method_8112), (App)SiphoningBookCategory.CODEC.fieldOf("category").orElse((Object)SiphoningBookCategory.MISC).forGetter(SiphoningRecipe::getCategory), (App)Codec.list(IngredientWithAmount.CODEC, (int)1, (int)2).fieldOf("ingredients").forGetter(SiphoningRecipe::getIngredientsWithAmounts), (App)Codec.unboundedMap(EnchantmentCategory.CODEC, (Codec)class_9304.field_49386).fieldOf("enchantments").forGetter(SiphoningRecipe::getEnchantments), (App)Codec.INT.optionalFieldOf("experience_cost", (Object)5).forGetter(SiphoningRecipe::getExperienceCost), (App)Codec.INT.optionalFieldOf("time", (Object)4800).forGetter(SiphoningRecipe::getTime)).apply((Applicative)inst, SiphoningRecipe::new));
        public static final class_9139<class_9129, SiphoningRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::encode, Serializer::decode);

        protected Serializer() {
        }

        private static void encode(class_9129 buf, SiphoningRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            IngredientWithAmount.STREAM_CODEC.method_56433(class_9135.method_58000((int)2)).encode((Object)buf, recipe.getIngredientsWithAmounts());
            class_9135.method_56377(HashMap::new, (class_9139)class_9135.method_56383(EnchiridionRegistries.ENCHANTMENT_CATEGORY), (class_9139)class_9304.field_49387).encode((Object)buf, new HashMap<class_6880<EnchantmentCategory>, class_9304>(recipe.enchantments));
            buf.method_53002(recipe.experienceCost);
            buf.method_53002(recipe.time);
        }

        public static SiphoningRecipe decode(class_9129 buf) {
            String group = buf.method_19772();
            SiphoningBookCategory category = (SiphoningBookCategory)buf.method_10818(SiphoningBookCategory.class);
            List ingredients = (List)IngredientWithAmount.STREAM_CODEC.method_56433(class_9135.method_58000((int)2)).decode((Object)buf);
            Map enchantments = (Map)class_9135.method_56377(HashMap::new, EnchantmentCategory.STREAM_CODEC, (class_9139)class_9304.field_49387).decode((Object)buf);
            int experienceCost = buf.readInt();
            int time = buf.readInt();
            return new SiphoningRecipe(group, category, ingredients, enchantments, experienceCost, time);
        }

        public MapCodec<SiphoningRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SiphoningRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

