/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.EnchiridionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;

public class CreativeTabUtil {
    public static void addSiphoningTableToCreativeMenu(InsertionConsumer consumer) {
        consumer.insert(class_1802.field_8657.method_7854(), EnchiridionItems.SIPHONING_TABLE.method_7854(), class_1761.class_7705.field_40191);
    }

    public static void sortEnchantmentsBasedOnCategory(List<class_1799> stacks, Consumer<List<class_1799>> addConsumer, class_7225.class_7874 provider) {
        if (stacks.stream().noneMatch(stack -> EnchiridionUtil.getEnchantmentsOrStoredEnchantments(stack) != null)) {
            return;
        }
        ArrayList<Pair> indexList = new ArrayList<Pair>(IntStream.range(0, stacks.size()).mapToObj(i -> Pair.of((Object)i, (Object)((class_1799)stacks.get(i)))).toList());
        List<class_1792> itemList = indexList.stream().map(pair -> ((class_1799)pair.getSecond()).method_7909()).toList();
        ArrayList<class_1799> stackList = new ArrayList<class_1799>(indexList.stream().map(Pair::getSecond).toList());
        stackList.sort((o1, o2) -> {
            class_9304 enchantments = EnchiridionUtil.getEnchantmentsOrStoredEnchantments(o1);
            class_9304 enchantments2 = EnchiridionUtil.getEnchantmentsOrStoredEnchantments(o2);
            if (o1.method_7909() != o2.method_7909() || enchantments == null || enchantments2 == null) {
                return Integer.compare(itemList.indexOf(o1.method_7909()), itemList.indexOf(o2.method_7909()));
            }
            Pair<class_6880<class_1887>, Integer> enchantment = EnchiridionUtil.getFirstEnchantmentAndLevel(provider, enchantments);
            Pair<class_6880<class_1887>, Integer> enchantment2 = EnchiridionUtil.getFirstEnchantmentAndLevel(provider, enchantments2);
            int o1CategoryPriority = Optional.ofNullable(EnchiridionUtil.getFirstEnchantmentCategory(provider, enchantments, (ItemEnchantmentCategories)o1.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY))).map(category -> {
                if (!category.method_40227()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.comp_349()).priority();
            }).orElse(0);
            int o2CategoryPriority = Optional.ofNullable(EnchiridionUtil.getFirstEnchantmentCategory(provider, enchantments2, (ItemEnchantmentCategories)o2.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY))).map(category -> {
                if (!category.method_40227()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.comp_349()).priority();
            }).orElse(0);
            if (enchantment != null && enchantment2 != null && ((class_6880)enchantment.getFirst()).equals(enchantment2.getFirst())) {
                return Integer.compare((Integer)enchantment.getSecond(), (Integer)enchantment2.getSecond());
            }
            if (o1CategoryPriority == o2CategoryPriority && enchantment != null && enchantment2 != null) {
                return EnchiridionUtil.compareEnchantmentNames((class_6880<class_1887>)((class_6880)enchantment.getFirst()), (class_6880<class_1887>)((class_6880)enchantment2.getFirst()));
            }
            return Integer.compare(o2CategoryPriority, o1CategoryPriority);
        });
        addConsumer.accept(stackList);
    }

    public static interface InsertionConsumer {
        public void insert(class_1799 var1, class_1799 var2, class_1761.class_7705 var3);
    }
}

