/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentCategories;
import house.greenhouse.enchiridion.util.EnchiridionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class TooltipUtil {
    public static final class_2960 FABRIC_EVENT_PHASE = Enchiridion.asResource("enchantment_tooltip_modifications");

    public static void modifyEnchantmentTooltips(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 flag, List<class_2561> components) {
        if (tooltipContext.method_59527() == null || !stack.method_7942() && !stack.method_57826(class_9334.field_49643)) {
            return;
        }
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
        ArrayList enchantmentComponents = new ArrayList();
        class_9304 enchantments = EnchiridionUtil.getEnchantmentsOrStoredEnchantments(stack);
        if (enchantments == null) {
            return;
        }
        enchantments.method_57409(tooltipContext, enchantmentComponents::add, flag);
        enchantmentComponents.sort((o1, o2) -> {
            Optional o1Enchantment = tooltipContext.method_59527().method_46762(class_7924.field_41265).method_56882(e -> o1.method_44745(e.comp_2686())).method_42017().findFirst();
            Optional o2Enchantment = tooltipContext.method_59527().method_46762(class_7924.field_41265).method_56882(e -> o2.method_44745(e.comp_2686())).method_42017().findFirst();
            if (o1Enchantment.isEmpty() || o2Enchantment.isEmpty()) {
                return Integer.compare(components.indexOf(o1), components.indexOf(o2));
            }
            class_6880<EnchantmentCategory> category = categories.findFirstCategory((class_6880<class_1887>)((class_6880)o1Enchantment.get()));
            class_6880<EnchantmentCategory> category2 = categories.findFirstCategory((class_6880<class_1887>)((class_6880)o2Enchantment.get()));
            int categoryPriority = 0;
            int category2Priority = 0;
            if (category != null && category.method_40227()) {
                categoryPriority = ((EnchantmentCategory)category.comp_349()).priority();
            }
            if (category2 != null && category2.method_40227()) {
                category2Priority = ((EnchantmentCategory)category2.comp_349()).priority();
            }
            return Integer.compare(category2Priority, categoryPriority);
        });
        boolean hasShiftDown = class_437.method_25442();
        ArrayList<class_2561> originalComponents = new ArrayList<class_2561>(components);
        int processed = -1;
        int enchantmentEndIndex = -1;
        boolean descriptionsEnabled = false;
        HashMap<class_6880.class_6883, Integer> categoriesToProcess = new HashMap<class_6880.class_6883, Integer>();
        block0: for (int i = 0; i < enchantmentComponents.size(); ++i) {
            class_2561 component = (class_2561)enchantmentComponents.get(i);
            Optional enchantment = tooltipContext.method_59527().method_46762(class_7924.field_41265).method_56882(e -> component.method_44745(e.comp_2686())).method_42017().findFirst();
            if (enchantment.isEmpty()) continue;
            for (int j = 0; j < originalComponents.size(); ++j) {
                class_2561 toReplace = (class_2561)originalComponents.get(j);
                if (enchantmentComponents.stream().noneMatch(comp -> comp.equals((Object)toReplace)) || processed >= j) continue;
                processed = j;
                class_6880.class_6883 category = categories.findFirstCategory((class_6880<class_1887>)((class_6880)enchantment.get()));
                if (category == null) {
                    category = class_310.method_1551().field_1687.method_30349().method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_46747(EnchiridionEnchantmentCategories.UNCATEGORISED);
                }
                class_5250 newComp = component.method_27661();
                if (category.method_40227()) {
                    class_2583 style = component.method_10866();
                    if (((EnchantmentCategory)category.comp_349()).color().isPresent()) {
                        style = style.method_27703(((EnchantmentCategory)category.comp_349()).color().get());
                    }
                    newComp = newComp.method_27661().method_27696(style);
                }
                enchantmentEndIndex = j + 1;
                if (descriptionsEnabled || originalComponents.stream().anyMatch(TooltipUtil::isEnchantmentDescription)) {
                    int index = -1;
                    for (int k = 0; k < originalComponents.size(); ++k) {
                        if (!((class_2561)originalComponents.get(k)).equals((Object)component)) continue;
                        index = k;
                        break;
                    }
                    if (index != -1) {
                        components.set(j + 1, (class_2561)originalComponents.get(index + 1));
                        ++enchantmentEndIndex;
                        descriptionsEnabled = true;
                    }
                }
                if (hasShiftDown && !categoriesToProcess.containsKey(category)) {
                    categoriesToProcess.put(category, j + categoriesToProcess.size());
                }
                components.set(j, (class_2561)newComp);
                continue block0;
            }
        }
        if (!hasShiftDown && !TooltipUtil.hasShiftTooltip(components)) {
            components.add(enchantmentEndIndex, (class_2561)class_2561.method_43471((String)"enchiridion.expand_categories.message").method_27692(class_124.field_1063));
        } else {
            int first = categoriesToProcess.values().stream().min(Comparator.comparingInt(value -> value)).orElse(-1);
            if (first == -1) {
                return;
            }
            for (Map.Entry entry : categoriesToProcess.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).toList()) {
                class_6880 category = (class_6880)entry.getKey();
                class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080);
                if (((EnchantmentCategory)category.comp_349()).color().isPresent()) {
                    style = class_2583.field_24360.method_27703(((EnchantmentCategory)category.comp_349()).color().get());
                }
                components.add((Integer)entry.getValue(), (class_2561)((EnchantmentCategory)category.comp_349()).name().method_27661().method_27696(style));
                ++enchantmentEndIndex;
            }
            originalComponents = new ArrayList<class_2561>(components);
            for (int i = first; i < enchantmentEndIndex; ++i) {
                if (categoriesToProcess.containsValue(i)) continue;
                components.set(i, (class_2561)class_2561.method_43470((String)"-  ").method_27692(class_124.field_1080).method_10852((class_2561)originalComponents.get(i)));
            }
        }
    }

    private static boolean hasShiftTooltip(List<class_2561> components) {
        return components.stream().anyMatch(component -> TooltipUtil.checkTranslatableKey(component, contents -> contents.method_11022().equals("enchdesc.activate.message")));
    }

    private static boolean isEnchantmentDescription(class_2561 component) {
        return TooltipUtil.checkTranslatableKey(component, contents -> contents.method_11022().startsWith("enchantment.") && contents.method_11022().endsWith(".desc"));
    }

    private static boolean checkTranslatableKey(class_2561 component, Predicate<class_2588> predicate) {
        class_2588 translatable;
        class_7417 contents = null;
        if (component instanceof class_5250) {
            class_5250 mutable = (class_5250)component;
            if (mutable.method_10855().stream().anyMatch(c -> TooltipUtil.checkTranslatableKey(c, predicate))) {
                return true;
            }
            contents = mutable.method_10851();
        }
        if (contents == null) {
            return false;
        }
        return contents instanceof class_2588 && predicate.test(translatable = (class_2588)contents);
    }
}

