/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion;

import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.platform.EnchiridionPlatformHelper;
import house.greenhouse.greenhouseconfig.api.GreenhouseConfigHolder;
import house.greenhouse.greenhouseconfig.api.lang.ConfigLang;
import house.greenhouse.greenhouseconfig.api.util.Late;
import house.greenhouse.greenhouseconfig.jsonc.JsonCLang;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enchiridion {
    public static final String MOD_ID = "enchiridion";
    public static final String MOD_NAME = "Enchiridion";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Enchiridion");
    public static final Set<String> ENCHANTMENT_DESCRIPTION_MODS = Set.of("enchancement", "enchdesc", "idwtialsimmoedm", "item_descriptions", "item-descriptions");
    private static EnchiridionPlatformHelper helper;
    public static RegistryAccess preLoadAccess;
    public static final GreenhouseConfigHolder<EnchiridionConfig> CONFIG;

    public static void init(EnchiridionPlatformHelper helper) {
        Enchiridion.helper = helper;
        EnchiridionLootContextParamSets.registerAll();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static EnchiridionPlatformHelper getHelper() {
        return helper;
    }

    static {
        CONFIG = GreenhouseConfigHolder.split((String)MOD_ID, EnchiridionConfig.CLIENT_CODEC, (Object)EnchiridionConfig.CLIENT_DEFAULT, EnchiridionConfig.SERVER_CODEC, (Object)EnchiridionConfig.SERVER_DEFAULT, (ConfigLang)JsonCLang.INSTANCE).postRegistryPopulation((provider, enchiridionConfig) -> {
            if (enchiridionConfig.client() != null) {
                enchiridionConfig.client().categoryColorOverrides().keySet().forEach(lateHolder -> lateHolder.bind(provider, s -> {}));
            }
        }).postRegistryDepopulation(enchiridionConfig -> {
            if (enchiridionConfig.client() != null) {
                enchiridionConfig.client().categoryColorOverrides().keySet().forEach(Late::unbind);
            }
        }).networkSynchronized(enchiridionConfig -> EnchiridionConfig.streamCodec(enchiridionConfig.client())).build();
    }
}

