/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.category;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;

public record EnchantmentCategory(HolderSet<Enchantment> acceptedEnchantments, Component name, CategoryVisuals visuals, Optional<Integer> limit, float tradeChance, int priority) {
    public static final Codec<Holder<EnchantmentCategory>> CODEC = RegistryFixedCodec.create(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<EnchantmentCategory>> STREAM_CODEC = ByteBufCodecs.holderRegistry(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final Codec<EnchantmentCategory> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT, (Codec)Enchantment.DIRECT_CODEC).fieldOf("accepted_enchantments").forGetter(EnchantmentCategory::acceptedEnchantments), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(EnchantmentCategory::name), (App)CategoryVisuals.DIRECT_CODEC.fieldOf("visuals").forGetter(EnchantmentCategory::visuals), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("limit").forGetter(EnchantmentCategory::limit), (App)Codec.FLOAT.optionalFieldOf("trade_chance", (Object)Float.valueOf(0.5f)).forGetter(EnchantmentCategory::tradeChance), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(EnchantmentCategory::priority)).apply((Applicative)inst, EnchantmentCategory::new));
    public static final Codec<ResourceKey<EnchantmentCategory>> RESOURCE_KEY_CODEC = ResourceKey.codec(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final StreamCodec<ByteBuf, ResourceKey<EnchantmentCategory>> RESOURCE_KEY_STREAM_CODEC = ResourceKey.streamCodec(EnchiridionRegistries.ENCHANTMENT_CATEGORY);

    public static Builder builder(HolderSet<Enchantment> acceptedEnchantments, CategoryVisuals visuals) {
        return new Builder(acceptedEnchantments, visuals);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        int n;
        float f;
        Component otherEnchantments;
        Object object;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EnchantmentCategory)) return false;
        EnchantmentCategory enchantmentCategory = (EnchantmentCategory)obj;
        try {
            object = enchantmentCategory.acceptedEnchantments();
            otherEnchantments = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        object = enchantmentCategory.name();
        Component otherName = object;
        Object otherVisuals = object = enchantmentCategory.visuals();
        Object otherLimit = object = enchantmentCategory.limit();
        float otherChance = f = enchantmentCategory.tradeChance();
        int otherPriority = n = enchantmentCategory.priority();
        if (!otherEnchantments.equals(this.acceptedEnchantments)) return false;
        if (!otherName.equals((Object)this.name)) return false;
        if (!((CategoryVisuals)otherVisuals).equals(this.visuals)) return false;
        if (!((Optional)otherLimit).equals(this.limit)) return false;
        if (otherChance != this.tradeChance) return false;
        if (otherPriority != this.priority) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acceptedEnchantments, this.name, this.visuals, this.limit, Float.valueOf(this.tradeChance), this.priority);
    }

    public static class Builder {
        private final HolderSet<Enchantment> acceptedEnchantments;
        private CategoryVisuals visuals;
        private Optional<Integer> limit = Optional.empty();
        private float modelIndex = Float.NEGATIVE_INFINITY;
        private float tradeChance = 0.5f;
        private int priority = 0;

        protected Builder(HolderSet<Enchantment> acceptedEnchantments, CategoryVisuals visuals) {
            this.acceptedEnchantments = acceptedEnchantments;
            this.visuals = visuals;
        }

        public Builder limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder tradeChance(float tradeChance) {
            this.tradeChance = tradeChance;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public EnchantmentCategory build(ResourceLocation id) {
            return new EnchantmentCategory(this.acceptedEnchantments, (Component)Component.translatable((String)("enchiridion.category." + id.toLanguageKey())), this.visuals, this.limit, this.tradeChance, this.priority);
        }
    }
}

