/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AttributeTransferEffect {
    public static final Codec<AttributeTransferEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Attribute.CODEC.fieldOf("from").forGetter(AttributeTransferEffect::from), (App)Attribute.CODEC.fieldOf("to").forGetter(AttributeTransferEffect::to), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(AttributeTransferEffect::id), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(AttributeTransferEffect::operation), (App)EnchantmentValueEffect.CODEC.fieldOf("effect").forGetter(AttributeTransferEffect::effect), (App)Codec.BOOL.optionalFieldOf("subtract_base", (Object)false).forGetter(AttributeTransferEffect::includeBase)).apply((Applicative)inst, AttributeTransferEffect::new));
    private final Holder<Attribute> from;
    private final Holder<Attribute> to;
    private final ResourceLocation id;
    private final AttributeModifier.Operation operation;
    private final EnchantmentValueEffect effect;
    private final boolean subtractBase;
    private double previousModifierValue = Double.NaN;

    public AttributeTransferEffect(Holder<Attribute> from, Holder<Attribute> to, ResourceLocation id, AttributeModifier.Operation operation, EnchantmentValueEffect effect, boolean subtractBase) {
        this.from = from;
        this.to = to;
        this.id = id;
        this.operation = operation;
        this.effect = effect;
        this.subtractBase = subtractBase;
    }

    public static void apply(LivingEntity entity) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LootParams.Builder params = new LootParams.Builder(level2).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        for (Object2IntMap.Entry enchantment2 : Stream.of(EquipmentSlot.values()).flatMap(slot -> Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), entity.getItemBySlot(slot)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot))).filter(enchantment -> ((Holder)enchantment.getKey()).isBound() && !((Enchantment)((Holder)enchantment.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER).isEmpty()).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantment2.getIntValue());
            LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty());
            List effects = ((Enchantment)((Holder)enchantment2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER);
            for (ConditionalEffect effect : effects) {
                if (!effect.matches(context)) {
                    if (!entity.getAttributes().hasAttribute(((AttributeTransferEffect)effect.effect()).to) || !Objects.requireNonNull(entity.getAttribute(((AttributeTransferEffect)effect.effect()).to)).hasModifier(((AttributeTransferEffect)effect.effect()).id)) continue;
                    Objects.requireNonNull(entity.getAttribute(((AttributeTransferEffect)effect.effect()).to)).removeModifier(((AttributeTransferEffect)effect.effect()).id);
                    ((AttributeTransferEffect)effect.effect()).previousModifierValue = Double.NaN;
                    continue;
                }
                ((AttributeTransferEffect)effect.effect()).applyAttribute(context, entity, enchantment2.getIntValue());
            }
        }
    }

    public static void clearInvalidEffects(LivingEntity entity, ItemStack stack) {
        if (!(entity.level() instanceof ServerLevel)) {
            return;
        }
        List<Object2IntMap.Entry> enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(holderEntry -> ((Holder)holderEntry.getKey()).isBound() && !((Enchantment)((Holder)holderEntry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER).isEmpty()).toList();
        for (Object2IntMap.Entry enchantment : enchantments) {
            List effects = ((Enchantment)((Holder)enchantment.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER);
            for (ConditionalEffect effect : effects) {
                if (!entity.getAttributes().hasAttribute(((AttributeTransferEffect)effect.effect()).to())) continue;
                Objects.requireNonNull(entity.getAttribute(((AttributeTransferEffect)effect.effect()).to)).removeModifier(((AttributeTransferEffect)effect.effect()).id);
                ((AttributeTransferEffect)effect.effect()).previousModifierValue = Double.NaN;
            }
        }
    }

    private void applyAttribute(LootContext context, LivingEntity entity, int enchantmentLevel) {
        if (!entity.getAttributes().hasAttribute(this.to) || Mth.equal((double)this.previousModifierValue, (double)entity.getAttributeValue(this.from))) {
            return;
        }
        if (!Mth.equal((double)this.previousModifierValue, (double)entity.getAttributeValue(this.from))) {
            Objects.requireNonNull(entity.getAttribute(this.to)).removeModifier(this.id);
            this.previousModifierValue = entity.getAttributeValue(this.from);
        }
        double value = entity.getAttributeValue(this.from);
        if (this.subtractBase) {
            value -= entity.getAttributeBaseValue(this.from);
        }
        Objects.requireNonNull(entity.getAttribute(this.to)).addOrUpdateTransientModifier(this.constructModifier(context.getRandom(), value, enchantmentLevel));
    }

    private AttributeModifier constructModifier(RandomSource random, double fromValue, int enchantmentLevel) {
        return new AttributeModifier(this.id, (double)this.effect.process(enchantmentLevel, random, (float)fromValue), this.operation);
    }

    public Holder<Attribute> from() {
        return this.from;
    }

    public Holder<Attribute> to() {
        return this.to;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public AttributeModifier.Operation operation() {
        return this.operation;
    }

    public EnchantmentValueEffect effect() {
        return this.effect;
    }

    public boolean includeBase() {
        return this.subtractBase;
    }
}

