/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record ReturnToUsedHandEffect(Optional<LootItemCondition> weaponCondition, Optional<LootItemCondition> ammoCondition) {
    public static final Codec<ReturnToUsedHandEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ConditionalEffect.conditionCodec((LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).optionalFieldOf("weapon_requirements").forGetter(ReturnToUsedHandEffect::weaponCondition), (App)ConditionalEffect.conditionCodec((LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).optionalFieldOf("ammo_requirements").forGetter(ReturnToUsedHandEffect::ammoCondition)).apply((Applicative)inst, ReturnToUsedHandEffect::new));

    public static void setAmmoPreferredHand(ItemStack ammo, ItemStack weapon, ServerLevel level, InteractionHand hand) {
        if (hand != InteractionHand.OFF_HAND) {
            return;
        }
        if (Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), weapon).keySet().stream().anyMatch(enchantment -> !((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).isEmpty())) {
            LootParams.Builder weaponParams = new LootParams.Builder(level).withParameter(LootContextParams.TOOL, (Object)weapon);
            LootParams.Builder ammoParams = new LootParams.Builder(level).withParameter(LootContextParams.TOOL, (Object)ammo);
            if (Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), weapon).entrySet().stream().anyMatch(entry -> {
                if (!((Holder)entry.getKey()).isBound()) {
                    return false;
                }
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                weaponParams.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                ammoParams.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                return !(enchantment.getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).isEmpty() || !enchantment.getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).stream().allMatch(effect -> effect.weaponCondition().isEmpty()) && !enchantment.getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).stream().anyMatch(effect -> effect.weaponCondition().stream().allMatch(condition -> condition.test((Object)new LootContext.Builder(weaponParams.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty())))) || !enchantment.getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).stream().allMatch(effect -> effect.ammoCondition().isEmpty()) && !enchantment.getEffects(EnchiridionEnchantmentEffectComponents.RETURN_TO_USED_HAND).stream().anyMatch(effect -> effect.ammoCondition().stream().allMatch(condition -> condition.test((Object)new LootContext.Builder(ammoParams.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty())))));
            })) {
                ammo.set(EnchiridionDataComponents.RETURN_TO_OFFHAND, (Object)Unit.INSTANCE);
            }
        }
    }
}

