/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.enchantment.effect.RidingTarget;
import java.util.Optional;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record RidingConditionalEffect<T extends EnchantmentLocationBasedEffect>(RidingTarget enchanted, RidingTarget affected, T effect, Optional<LootItemCondition> requirements) {
    public RidingConditionalEffect(RidingTarget enchanted, RidingTarget affected, T effect, LootItemCondition requirements) {
        this(enchanted, affected, effect, Optional.of(requirements));
    }

    public static <S extends EnchantmentLocationBasedEffect> Codec<RidingConditionalEffect<S>> codec(Codec<S> effectCodec, LootContextParamSet paramSet) {
        return RecordCodecBuilder.create(inst -> inst.group((App)RidingTarget.CODEC.fieldOf("enchanted").forGetter(RidingConditionalEffect::enchanted), (App)RidingTarget.CODEC.fieldOf("affected").forGetter(RidingConditionalEffect::affected), (App)effectCodec.fieldOf("effect").forGetter(RidingConditionalEffect::effect), (App)ConditionalEffect.conditionCodec((LootContextParamSet)paramSet).optionalFieldOf("requirements").forGetter(RidingConditionalEffect::requirements)).apply((Applicative)inst, RidingConditionalEffect::new));
    }

    public boolean matches(LootContext context) {
        return this.requirements.map(condition -> condition.test((Object)context)).orElse(true);
    }
}

