/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public record RunFunctionOnLootEffect(List<LootItemFunction> functions, Optional<ItemPredicate> predicate, Optional<Either<TagKey<LootTable>, List<ResourceKey<LootTable>>>> lootTables) {
    public static final Codec<RunFunctionOnLootEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootItemFunctions.ROOT_CODEC.listOf().fieldOf("functions").forGetter(RunFunctionOnLootEffect::functions), (App)ItemPredicate.CODEC.optionalFieldOf("predicate").forGetter(RunFunctionOnLootEffect::predicate), (App)Codec.either((Codec)TagKey.hashedCodec((ResourceKey)Registries.LOOT_TABLE), (Codec)Codec.withAlternative((Codec)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).listOf(), (Codec)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE), List::of)).optionalFieldOf("applicable_tables").forGetter(RunFunctionOnLootEffect::lootTables)).apply((Applicative)inst, RunFunctionOnLootEffect::new));

    public RunFunctionOnLootEffect(List<LootItemFunction> functions) {
        this(functions, Optional.empty(), Optional.empty());
    }

    public RunFunctionOnLootEffect(List<LootItemFunction> functions, List<ResourceKey<LootTable>> tableTag) {
        this(functions, Optional.empty(), Optional.of(Either.right(tableTag)));
    }

    public RunFunctionOnLootEffect(List<LootItemFunction> functions, TagKey<LootTable> tableTag) {
        this(functions, Optional.empty(), Optional.of(Either.left(tableTag)));
    }

    public RunFunctionOnLootEffect(List<LootItemFunction> functions, ItemPredicate predicate) {
        this(functions, Optional.of(predicate), Optional.empty());
    }

    public RunFunctionOnLootEffect(List<LootItemFunction> functions, ItemPredicate predicate, List<ResourceKey<LootTable>> tableTag) {
        this(functions, Optional.of(predicate), Optional.of(Either.right(tableTag)));
    }

    public RunFunctionOnLootEffect(List<LootItemFunction> functions, ItemPredicate predicate, TagKey<LootTable> tableTag) {
        this(functions, Optional.of(predicate), Optional.of(Either.left(tableTag)));
    }

    public static void modifyLoot(RunFunctionOnLootEffect effect, List<ItemStack> stacks, LootContext context, Holder<LootTable> tableHolder) {
        Registry lootTables = context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack newStack = stacks.get(i).copy();
            if (effect.predicate.isPresent() && !effect.predicate.get().test(newStack) || effect.lootTables.isPresent() && !effect.lootTables.map(either -> (Boolean)either.map(tableTagKey -> lootTables.getTag(tableTagKey).map(holders -> holders.contains(tableHolder)).orElse(false), resourceKeys -> resourceKeys.stream().anyMatch(arg_0 -> ((Holder)tableHolder).is(arg_0)))).orElse(false).booleanValue()) continue;
            for (LootItemFunction function : effect.functions) {
                newStack = (ItemStack)function.apply((Object)newStack, (Object)context);
            }
            stacks.set(i, newStack);
        }
    }
}

