/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record AreaEffect(LevelBasedValue radius, EnchantmentEntityEffect effect, EnumSet<AreaTarget> unaffected) implements EnchantmentEntityEffect
{
    public static final MapCodec<AreaEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("width").forGetter(AreaEffect::radius), (App)EnchantmentEntityEffect.CODEC.fieldOf("effect").forGetter(AreaEffect::effect), (App)AreaTarget.SET_CODEC.optionalFieldOf("unaffected", EnumSet.of(AreaTarget.THIS)).forGetter(AreaEffect::unaffected)).apply((Applicative)inst, AreaEffect::new));

    public void apply(ServerLevel serverLevel, int i, @NotNull EnchantedItemInUse enchantedItemInUse, @NotNull Entity entity, @NotNull Vec3 vec3) {
        serverLevel.getEntities(EntityTypeTest.forClass(LivingEntity.class), living -> this.unaffected.stream().noneMatch(areaTarget -> areaTarget.canTarget((Entity)enchantedItemInUse.owner(), (LivingEntity)living)) && living.distanceTo(entity) < this.radius.calculate(i)).forEach(living -> this.effect.apply(serverLevel, i, enchantedItemInUse, (Entity)living, vec3));
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }

    public static enum AreaTarget implements StringRepresentable
    {
        THIS("this", Entity::is),
        ATTACKER("attacker", (entity, entity2) -> {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getLastDamageSource().getEntity() != null) {
                return living.getLastDamageSource().getEntity().is((Entity)entity2);
            }
            return false;
        }),
        DAMAGING_ENTITY("damaging_entity", (entity, entity2) -> {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getLastDamageSource().getDirectEntity() != null) {
                return living.getLastDamageSource().getDirectEntity().is((Entity)entity2);
            }
            return false;
        }),
        TARGET("target", (entity, living) -> living.getLastDamageSource().getEntity().is(entity)),
        OWNER("owner", AreaTarget::isOwner),
        TAMED("tamed", (entity, living) -> AreaTarget.isOwner((Entity)living, entity)),
        ALLIED("allied", (entity, living) -> entity.isAlliedTo((Entity)living));

        private String name;
        private BiPredicate<Entity, LivingEntity> predicate;
        public static final Codec<AreaTarget> CODEC;
        public static final Codec<EnumSet<AreaTarget>> SET_CODEC;

        private AreaTarget(String name, BiPredicate<Entity, LivingEntity> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        private static boolean isOwner(Entity entity, Entity living) {
            TraceableEntity traceable;
            OwnableEntity ownable;
            if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwner() != null) {
                return ownable.getOwner().is(living);
            }
            if (entity instanceof TraceableEntity && (traceable = (TraceableEntity)entity).getOwner() != null) {
                return traceable.getOwner().is(living);
            }
            return false;
        }

        public boolean canTarget(Entity entity, LivingEntity target) {
            return this.predicate.test(entity, target);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(AreaTarget::values);
            SET_CODEC = CODEC.listOf().xmap(EnumSet::copyOf, List::copyOf);
        }
    }
}

