/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record MultipleOfEffect(EnchantmentEntityEffect effect, LevelBasedValue amount) implements EnchantmentEntityEffect
{
    public static final MapCodec<MultipleOfEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)EnchantmentEntityEffect.CODEC.fieldOf("effect").forGetter(MultipleOfEffect::effect), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(MultipleOfEffect::amount)).apply((Applicative)inst, MultipleOfEffect::new));

    public void apply(@NotNull ServerLevel level, int enchantmentLevel, @NotNull EnchantedItemInUse item, @NotNull Entity entity, @NotNull Vec3 origin) {
        int amount = Mth.floor((float)this.amount().calculate(enchantmentLevel));
        for (int i = 0; i < amount; ++i) {
            this.effect.apply(level, enchantmentLevel, item, entity, origin);
        }
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

