/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.enchantment.effect.RidingTarget;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record RidingEntityEffect(RidingTarget target, EnchantmentEntityEffect effect, Optional<EntityPredicate> predicate) implements EnchantmentEntityEffect
{
    public static final MapCodec<RidingEntityEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RidingTarget.CODEC.fieldOf("target").forGetter(RidingEntityEffect::target), (App)EnchantmentEntityEffect.CODEC.fieldOf("effect").forGetter(RidingEntityEffect::effect), (App)EntityPredicate.CODEC.optionalFieldOf("predicate").forGetter(RidingEntityEffect::predicate)).apply((Applicative)inst, RidingEntityEffect::new));

    public RidingEntityEffect(RidingTarget target, EnchantmentEntityEffect effect) {
        this(target, effect, Optional.empty());
    }

    public RidingEntityEffect(RidingTarget target, EnchantmentEntityEffect effect, EntityPredicate predicate) {
        this(target, effect, Optional.of(predicate));
    }

    public void apply(@NotNull ServerLevel serverLevel, int level, @NotNull EnchantedItemInUse enchantedItem, @NotNull Entity entity, @NotNull Vec3 origin) {
        List<Entity> entities = this.target.getEntities(entity);
        for (Entity target : entities) {
            if (!this.predicate.isEmpty() && !this.predicate.get().matches(serverLevel, target.position(), target)) continue;
            this.effect.apply(serverLevel, level, enchantedItem, target, target.position());
        }
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

