/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.SidedEnchantmentEntityEffectInstance;
import house.greenhouse.enchiridion.api.util.Side;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record CommonApplyVelocityEffect(LevelBasedValue x, LevelBasedValue y, LevelBasedValue z, boolean add, boolean applyToView, EnumSet<Side> sides) implements SidedEnchantmentEntityEffectInstance
{
    public static final MapCodec<CommonApplyVelocityEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("x").forGetter(CommonApplyVelocityEffect::x), (App)LevelBasedValue.CODEC.fieldOf("y").forGetter(CommonApplyVelocityEffect::y), (App)LevelBasedValue.CODEC.fieldOf("z").forGetter(CommonApplyVelocityEffect::z), (App)Codec.BOOL.optionalFieldOf("add", (Object)false).forGetter(CommonApplyVelocityEffect::add), (App)Codec.BOOL.optionalFieldOf("apply_to_view", (Object)false).forGetter(CommonApplyVelocityEffect::applyToView), (App)Side.CODEC.listOf().xmap(EnumSet::copyOf, List::copyOf).optionalFieldOf("sides", EnumSet.of(Side.CLIENT, Side.SERVER)).forGetter(CommonApplyVelocityEffect::sides)).apply((Applicative)inst, CommonApplyVelocityEffect::new));

    @Override
    public void apply(Level level, int enchantmentLevel, EnchantedItemInUse enchantedItem, Entity entity, Vec3 origin) {
        Vec3 toApply = new Vec3((double)this.x.calculate(enchantmentLevel), (double)this.y.calculate(enchantmentLevel), (double)this.z.calculate(enchantmentLevel));
        if (this.applyToView) {
            float xDelta = Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180)));
            float zDelta = Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180)));
            float yDelta = (float)((double)entity.getXRot() * (Math.PI / 180) / 1.5707963267948966);
            toApply = new Vec3(toApply.x * (double)zDelta - toApply.z * (double)xDelta, (double)(-yDelta) * toApply.y, toApply.z * (double)zDelta + toApply.x * (double)xDelta);
        }
        Vec3 appliedVelocity = this.add ? entity.getDeltaMovement().add(toApply) : toApply;
        entity.setDeltaMovement(appliedVelocity);
        entity.hasImpulse = true;
    }

    public MapCodec<CommonApplyVelocityEffect> codec() {
        return CODEC;
    }

    @Override
    public EnumSet<Side> validSides() {
        return this.sides;
    }
}

