/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EnchantFromTrade(IntProvider amount, HolderSet<Enchantment> enchantments, HolderSet<EnchantmentCategory> categories, IntProvider level, boolean allowDuplicateEnchantments, boolean allowDuplicateCategories) implements EnchantmentProvider
{
    public static final ResourceLocation ID = Enchiridion.id("enchant_from_trade");
    public static final MapCodec<EnchantFromTrade> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IntProvider.POSITIVE_CODEC.optionalFieldOf("amount", (Object)ConstantInt.of((int)1)).forGetter(EnchantFromTrade::amount), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(EnchantFromTrade::enchantments), (App)RegistryCodecs.homogeneousList(EnchiridionRegistries.ENCHANTMENT_CATEGORY).fieldOf("categories").forGetter(EnchantFromTrade::categories), (App)IntProvider.CODEC.fieldOf("level").forGetter(EnchantFromTrade::level), (App)Codec.BOOL.optionalFieldOf("allow_duplicate_enchantments", (Object)false).forGetter(EnchantFromTrade::allowDuplicateEnchantments), (App)Codec.BOOL.optionalFieldOf("allow_duplicate_categories", (Object)false).forGetter(EnchantFromTrade::allowDuplicateCategories)).apply((Applicative)inst, EnchantFromTrade::new));

    public void enchant(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ItemEnchantments.Mutable mutable, @NotNull RandomSource random, @NotNull DifficultyInstance difficulty) {
        ArrayList<Holder> operatedEnchantments = new ArrayList<Holder>();
        ArrayList<Holder<EnchantmentCategory>> operatedCategories = new ArrayList<Holder<EnchantmentCategory>>();
        int am = this.amount.sample(random);
        for (int i = 0; i < am; ++i) {
            List<Holder> allowedEnchantments = this.enchantments.stream().filter(holder -> !operatedEnchantments.contains(holder)).toList();
            Holder<EnchantmentCategory> category = this.chooseCategory(stack, operatedCategories, random);
            if (category == null) break;
            Holder<EnchantmentCategory> finalCategory = category;
            List<Holder> filteredCategoricalEnchantment = allowedEnchantments.stream().filter(enchantmentHolder -> ((EnchantmentCategory)finalCategory.value()).acceptedEnchantments().contains(enchantmentHolder)).toList();
            if (filteredCategoricalEnchantment.isEmpty()) break;
            Holder enchantment = filteredCategoricalEnchantment.get(random.nextInt(filteredCategoricalEnchantment.size()));
            operatedCategories.add(category);
            operatedEnchantments.add(enchantment);
            mutable.upgrade(enchantment, Mth.clamp((int)this.level.sample(random), (int)((Enchantment)enchantment.value()).getMinLevel(), (int)((Enchantment)enchantment.value()).getMaxLevel()));
            EnchantmentCategoryUtil.updateCategories(stack, categories -> categories.overwrite(category, (Holder<Enchantment>)enchantment));
        }
    }

    @Nullable
    private Holder<EnchantmentCategory> chooseCategory(ItemStack stack, List<Holder<EnchantmentCategory>> operatedCategories, RandomSource random) {
        Holder potential;
        List<Holder> potentialCategories = this.categories.stream().filter(category -> category.isBound() && (this.allowDuplicateCategories || new HashSet(operatedCategories).containsAll(this.categories.stream().toList()) || !operatedCategories.contains(category)) && this.enchantments.stream().filter(enchantmentHolder -> EnchantmentCategoryUtil.getAllEnchantmentCategories((HolderLookup.Provider)Enchiridion.getHelper().getRegistryAccess(), (Holder<Enchantment>)enchantmentHolder).contains(category)).anyMatch(enchantment -> ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)) && this.enchantments.stream().filter(enchantmentHolder -> EnchantmentCategoryUtil.getAllEnchantmentCategories((HolderLookup.Provider)Enchiridion.getHelper().getRegistryAccess(), (Holder<Enchantment>)enchantmentHolder).contains(category)).allMatch(enchantmentHolder -> EnchantmentCategoryUtil.isValidInCategory((Holder<EnchantmentCategory>)category, EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().map(Map.Entry::getKey).toList(), (Holder<Enchantment>)enchantmentHolder))).sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority())).toList();
        if (potentialCategories.isEmpty()) {
            return null;
        }
        if (potentialCategories.size() == 1) {
            return potentialCategories.getFirst();
        }
        Holder category2 = this.categories.get(0);
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext() && !(potential = (Holder)iterator.next()).equals((Object)category2)) {
            if (!(random.nextFloat() < ((EnchantmentCategory)potential.value()).tradeChance())) continue;
            category2 = potential;
            break;
        }
        return category2;
    }

    @NotNull
    public MapCodec<EnchantFromTrade> codec() {
        return CODEC;
    }
}

