/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.util.EnchiridionCodecs;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public record BlockRaycastLootCondition(Vec3 direction, BlockPredicate predicate, ClipContext.Block blockContext, ClipContext.Fluid fluidContext) implements LootItemCondition
{
    public static final MapCodec<BlockRaycastLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Vec3.CODEC.fieldOf("direction").forGetter(BlockRaycastLootCondition::direction), (App)BlockPredicate.CODEC.fieldOf("predicate").forGetter(BlockRaycastLootCondition::predicate), (App)EnchiridionCodecs.BLOCK_RAYCAST_CONTEXT_CODEC.optionalFieldOf("block_context", (Object)ClipContext.Block.COLLIDER).forGetter(BlockRaycastLootCondition::blockContext), (App)EnchiridionCodecs.FLUID_RAYCAST_CONTEXT_CODEC.optionalFieldOf("fluid_context", (Object)ClipContext.Fluid.ANY).forGetter(BlockRaycastLootCondition::fluidContext)).apply((Applicative)inst, BlockRaycastLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        ServerLevel level = lootContext.getLevel();
        Vec3 pos = (Vec3)lootContext.getParam(LootContextParams.ORIGIN);
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        return this.predicate.test((Object)level, (Object)level.clip(new ClipContext(pos, pos.add(this.direction.x(), this.direction.y(), this.direction.z()), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity != null ? CollisionContext.of((Entity)entity) : CollisionContext.empty())).getBlockPos().immutable());
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Vec3 direction;
        private BlockPredicate predicate = BlockPredicate.alwaysTrue();
        private boolean fluidsOnly = false;
        private ClipContext.Block blockContext = ClipContext.Block.COLLIDER;
        private ClipContext.Fluid fluidContext = ClipContext.Fluid.ANY;

        protected Builder(Vec3 direction) {
            this.direction = direction;
        }

        public static Builder builder(Vec3 direction) {
            return new Builder(direction);
        }

        public Builder predicate(BlockPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder blockContext(ClipContext.Block context) {
            this.blockContext = context;
            return this;
        }

        public Builder fluidContext(ClipContext.Fluid context) {
            this.fluidContext = context;
            return this;
        }

        public BlockRaycastLootCondition build() {
            return new BlockRaycastLootCondition(this.direction, this.predicate, this.blockContext, this.fluidContext);
        }
    }
}

