/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class CanTakeFallDamageLootCondition
implements LootItemCondition {
    public static final MapCodec<CanTakeFallDamageLootCondition> CODEC = MapCodec.unit((Object)new CanTakeFallDamageLootCondition());
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public LootItemCondition.Builder canTakeFallDamage() {
        return CanTakeFallDamageLootCondition::new;
    }

    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParam(LootContextParams.THIS_ENTITY);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return (double)entity.fallDistance > living.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
        }
        return false;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }
}

