/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.util.EntityUtil;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record EnchantedEntityFromToolLootCondition(LootItemCondition entityPredicate) implements LootItemCondition
{
    public static final MapCodec<EnchantedEntityFromToolLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootItemCondition.DIRECT_CODEC.fieldOf("entity_predicate").forGetter(EnchantedEntityFromToolLootCondition::entityPredicate)).apply((Applicative)inst, EnchantedEntityFromToolLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public static LootItemCondition.Builder entityFromTool(LootItemCondition.Builder condition) {
        return () -> new EnchantedEntityFromToolLootCondition(condition.build());
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext context) {
        ItemStack stack = (ItemStack)context.getParam(LootContextParams.TOOL);
        int enchantmentLevel = (Integer)context.getParam(LootContextParams.ENCHANTMENT_LEVEL);
        Entity entity = EntityUtil.getStackHolder(stack);
        if (entity == null) {
            return false;
        }
        LootParams params = new LootParams.Builder(context.getLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantmentLevel).create(LootContextParamSets.ENCHANTED_ENTITY);
        return this.entityPredicate.test((Object)new LootContext.Builder(params).create(Optional.empty()));
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.TOOL, LootContextParams.ENCHANTMENT_LEVEL);
    }
}

