/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.util.FloatRange;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record ToolUseDurationLootCondition(Optional<IntRange> tickRange, Optional<FloatRange> percentageRange) implements LootItemCondition
{
    public static final MapCodec<ToolUseDurationLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IntRange.CODEC.optionalFieldOf("tick_range").forGetter(ToolUseDurationLootCondition::tickRange), (App)FloatRange.CODEC.optionalFieldOf("percentage_range").forGetter(ToolUseDurationLootCondition::percentageRange)).apply((Applicative)inst, ToolUseDurationLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public boolean test(LootContext context) {
        LivingEntity living;
        Entity entity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isUsingItem()) {
            return false;
        }
        return this.tickRange.map(iRange -> iRange.test(context, living.getTicksUsingItem())).orElseGet(() -> this.percentageRange.map(fRange -> fRange.test(context, living.getTicksUsingItem() / living.getUseItem().getUseDuration(living))).orElse(false));
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private Optional<IntRange> tickRange = Optional.empty();
        private Optional<FloatRange> percentageRange = Optional.empty();

        protected Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder setTickRange(IntRange range) {
            this.tickRange = Optional.of(range);
            return this;
        }

        public Builder setPercentageRange(FloatRange range) {
            this.percentageRange = Optional.of(range);
            return this;
        }

        @NotNull
        public ToolUseDurationLootCondition build() {
            return new ToolUseDurationLootCondition(this.tickRange, this.percentageRange);
        }
    }
}

