/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.mutable.MutableFloat;

public class DamageUtil {
    public static DamageSource changeDamageType(DamageSource original, LivingEntity target) {
        EquipmentSlot[] equipmentSlotArray;
        LootContext context;
        Holder enchantment;
        ItemStack stack;
        LivingEntity living;
        EquipmentSlot[] equipmentSlotArray2;
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return original;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DamageSource source = original;
        LootParams.Builder params = DamageUtil.createDamageParams(serverLevel, source, target);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack2 = target.getItemBySlot(slot);
            for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)target.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack2).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                Holder enchantment2 = (Holder)entry2.getKey();
                LootContext context2 = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                for (TargetedConditionalEffect effect : ((Enchantment)enchantment2.value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE)) {
                    if (effect.enchanted() != EnchantmentTarget.VICTIM || !effect.matches(context2)) continue;
                    source = new DamageSource((Holder)effect.effect(), original.getEntity(), original.getDirectEntity(), original.getSourcePosition());
                }
            }
        }
        if (original.getEntity() != null && (equipmentSlotArray2 = original.getEntity()) instanceof LivingEntity) {
            living = (LivingEntity)equipmentSlotArray2;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stack = living.getItemBySlot(slot);
                for (Object2IntMap.Entry entry3 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)target.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                    enchantment = (Holder)entry3.getKey();
                    context = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry3.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE)) {
                        if (effect.enchanted() != EnchantmentTarget.ATTACKER || !effect.matches(context)) continue;
                        source = new DamageSource((Holder)effect.effect(), original.getEntity(), original.getDirectEntity(), original.getSourcePosition());
                    }
                }
            }
        }
        if (original.getDirectEntity() != null && (equipmentSlotArray = original.getDirectEntity()) instanceof LivingEntity) {
            living = (LivingEntity)equipmentSlotArray;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stack = living.getItemBySlot(slot);
                for (Object2IntMap.Entry entry3 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)living.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                    enchantment = (Holder)entry3.getKey();
                    context = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry3.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.DAMAGE_TYPE)) {
                        if (effect.enchanted() != EnchantmentTarget.DAMAGING_ENTITY || !effect.matches(context)) continue;
                        source = new DamageSource((Holder)effect.effect(), original.getEntity(), original.getDirectEntity(), original.getSourcePosition());
                    }
                }
            }
        }
        return source;
    }

    public static boolean bypassDamageCooldown(DamageSource source, LivingEntity target) {
        EquipmentSlot[] equipmentSlotArray;
        LootContext context;
        Holder enchantment;
        ItemStack stack;
        LivingEntity living;
        EquipmentSlot[] equipmentSlotArray2;
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder params = DamageUtil.createDamageParams(serverLevel, source, target);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack2 = target.getItemBySlot(slot);
            for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)target.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack2).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                Holder enchantment2 = (Holder)entry2.getKey();
                LootContext context2 = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                for (TargetedConditionalEffect effect : ((Enchantment)enchantment2.value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN)) {
                    if (effect.enchanted() != EnchantmentTarget.VICTIM || !effect.matches(context2)) continue;
                    return true;
                }
            }
        }
        if (source.getEntity() != null && (equipmentSlotArray2 = source.getEntity()) instanceof LivingEntity) {
            living = (LivingEntity)equipmentSlotArray2;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stack = living.getItemBySlot(slot);
                for (Object2IntMap.Entry entry3 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)living.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                    enchantment = (Holder)entry3.getKey();
                    context = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry3.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN)) {
                        if (effect.enchanted() != EnchantmentTarget.ATTACKER || !effect.matches(context)) continue;
                        return true;
                    }
                }
            }
        }
        if (source.getDirectEntity() != null && (equipmentSlotArray = source.getDirectEntity()) instanceof LivingEntity) {
            living = (LivingEntity)equipmentSlotArray;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stack = living.getItemBySlot(slot);
                for (Object2IntMap.Entry entry3 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)living.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                    enchantment = (Holder)entry3.getKey();
                    context = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry3.getIntValue()).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.BYPASS_DAMAGE_COOLDOWN)) {
                        if (effect.enchanted() != EnchantmentTarget.DAMAGING_ENTITY || !effect.matches(context)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static float modifyProtectionDamage(DamageSource source, float damageAmount, float protectionPoints, ProtectionAbsorbOperation operation, LivingEntity target) {
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return operation.absorb(damageAmount, protectionPoints);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder params = DamageUtil.createDamageParams(serverLevel, source, target);
        boolean modified = false;
        MutableFloat protectionPointCap = new MutableFloat(20.0f);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            LivingEntity passenger;
            Entity entity;
            if (!DamageUtil.modifyProtectionPointCapacity(target, slot, protectionPointCap, params, EnchiridionEnchantmentEffectComponents.DAMAGE_PROTECTION_CAPACITY) && (!((entity = target.getFirstPassenger()) instanceof LivingEntity) || !DamageUtil.modifyProtectionPointCapacity(passenger = (LivingEntity)entity, slot, protectionPointCap, params, EnchiridionEnchantmentEffectComponents.VEHICLE_DAMAGE_PROTECTION_CAPACITY))) continue;
            modified = true;
        }
        if (modified) {
            return DamageUtil.absorbWithCustomCapacity(damageAmount, protectionPoints, protectionPointCap.getValue().floatValue());
        }
        return operation.absorb(damageAmount, protectionPoints);
    }

    private static boolean modifyProtectionPointCapacity(LivingEntity living, EquipmentSlot slot, MutableFloat protectionPointCap, LootParams.Builder params, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> protectionPointsEffect) {
        ItemStack stack = living.getItemBySlot(slot);
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)living.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            Holder enchantment = (Holder)entry2.getKey();
            int enchantmentLevel = entry2.getIntValue();
            LootContext context = new LootContext.Builder(params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantmentLevel).create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
            for (ConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(protectionPointsEffect)) {
                if (!effect.matches(context)) continue;
                protectionPointCap.setValue(((EnchantmentValueEffect)effect.effect()).process(enchantmentLevel, living.getRandom(), protectionPointCap.getValue().floatValue()));
                return true;
            }
        }
        return false;
    }

    private static float absorbWithCustomCapacity(float damageAmount, float protectionPoints, float pointCapacity) {
        float cappedPoints = Math.min(protectionPoints, pointCapacity);
        return damageAmount * (1.0f - cappedPoints / 25.0f);
    }

    private static LootParams.Builder createDamageParams(ServerLevel level, DamageSource source, LivingEntity target) {
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)target);
        params.withParameter(LootContextParams.ORIGIN, (Object)(source.getSourcePosition() == null ? target.position() : source.getSourcePosition()));
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        return params;
    }

    public static interface ProtectionAbsorbOperation {
        public float absorb(float var1, float var2);
    }
}

