/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.ConditionalSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.ProjectileTrajectoryEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.duck.Duck_ServerSmashDamageSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class WeaponUtil {
    public static float modifyInaccuracy(ServerLevel serverLevel, ItemStack stack, EquipmentSlot slot, float original) {
        MutableFloat mutable = new MutableFloat(original);
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INACCURACY).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            int level = entry2.getIntValue();
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INACCURACY)) {
                LootContext lootContext;
                if (!effect.matches(lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                mutable.setValue(((EnchantmentValueEffect)effect.effect()).process(level, serverLevel.getRandom(), mutable.getValue().floatValue()));
            }
        }
        return mutable.getValue().floatValue();
    }

    @Nullable
    public static Vec3 modifyProjectileTrajectory(ServerLevel serverLevel, ItemStack stack, EquipmentSlot slot, Vec3 deltaMovement, float velocity) {
        boolean shouldModify = false;
        Vec3 normalized = deltaMovement.normalize();
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_TRAJECTORY).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            int level = entry2.getIntValue();
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_TRAJECTORY)) {
                LootContext lootContext;
                if (!effect.matches(lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                normalized = ((ProjectileTrajectoryEffect)effect.effect()).modifyTrajectory(normalized, level, serverLevel.getRandom());
                shouldModify = true;
            }
        }
        if (shouldModify) {
            return normalized.scale((double)velocity);
        }
        return null;
    }

    public static double modifyProjectileGravity(ServerLevel serverLevel, ItemStack stack, EquipmentSlot slot, double gravity) {
        MutableFloat projectileVelocity = new MutableFloat((Number)gravity);
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_GRAVITY).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            int level = entry2.getIntValue();
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_GRAVITY)) {
                LootContext lootContext;
                if (!effect.matches(lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                projectileVelocity.setValue(((EnchantmentValueEffect)effect.effect()).process(level, serverLevel.getRandom(), projectileVelocity.getValue().floatValue()));
            }
        }
        return projectileVelocity.getValue().floatValue();
    }

    public static float modifyProjectileVelocity(ServerLevel serverLevel, ItemStack stack, EquipmentSlot slot, float velocity) {
        MutableFloat projectileVelocity = new MutableFloat(velocity);
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_VELOCITY).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            int level = entry2.getIntValue();
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PROJECTILE_VELOCITY)) {
                LootContext lootContext;
                if (!effect.matches(lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                projectileVelocity.setValue(((EnchantmentValueEffect)effect.effect()).process(level, serverLevel.getRandom(), projectileVelocity.getValue().floatValue()));
            }
        }
        return projectileVelocity.getValue().floatValue();
    }

    public static float modifyFireworkDamage(ServerLevel serverLevel, ItemStack stack, Entity entity, DamageSource source, float original) {
        MutableFloat mutable = new MutableFloat(original);
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.FIREWORK_DAMAGE).isEmpty()).toList()) {
            int level = entry2.getIntValue();
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.FIREWORK_DAMAGE)) {
                LootContext lootContext;
                if (!effect.matches(lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty()))) continue;
                mutable.setValue(((EnchantmentValueEffect)effect.effect()).process(level, serverLevel.getRandom(), mutable.getValue().floatValue()));
            }
        }
        return mutable.getValue().floatValue();
    }

    public static void runHitAttackEffects(LivingEntity entity, Vec3 hitTarget) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)hitTarget);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            ItemEnchantments itemEnchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
            if (itemEnchantments == null || itemEnchantments.isEmpty()) continue;
            EnchantedItemInUse useItem = new EnchantedItemInUse(stack, slot, entity);
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.value()).matchingSlot(slot)) continue;
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty());
                for (ConditionalSidedEnchantmentEntityEffect effect : ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.HIT_ATTACK)) {
                    if (!effect.matches(context)) continue;
                    effect.effect().apply((Level)serverLevel, entry.getIntValue(), useItem, (Entity)entity, hitTarget);
                }
            }
        }
    }

    public static void runMissedAttackEffects(LivingEntity entity, Vec3 hitTarget) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)hitTarget);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            ItemEnchantments itemEnchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
            if (itemEnchantments == null || itemEnchantments.isEmpty()) continue;
            EnchantedItemInUse useItem = new EnchantedItemInUse(stack, slot, entity);
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.value()).matchingSlot(slot)) continue;
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty());
                for (ConditionalSidedEnchantmentEntityEffect effect : ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.MISSED_ATTACK)) {
                    if (!effect.matches(context)) continue;
                    effect.effect().apply((Level)serverLevel, entry.getIntValue(), useItem, (Entity)entity, hitTarget);
                }
            }
        }
    }

    public static void runPreAttackEffects(Entity target, DamageSource source, @Nullable ItemStack itemSource) {
        Entity entity;
        LivingEntity entity2;
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)target);
        params.withParameter(LootContextParams.ORIGIN, (Object)target.position());
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        if (target instanceof LivingEntity) {
            entity2 = (LivingEntity)target;
            entity = EquipmentSlot.values();
            int n = ((Entity)entity).length;
            for (int i = 0; i < n; ++i) {
                Entity slot = entity[i];
                ItemStack stack = entity2.getItemBySlot((EquipmentSlot)slot);
                ItemEnchantments itemEnchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
                if (itemEnchantments == null || itemEnchantments.isEmpty()) continue;
                EnchantedItemInUse useItem = new EnchantedItemInUse(stack, (EquipmentSlot)slot, entity2);
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    if (!((Enchantment)holder.value()).matchingSlot((EquipmentSlot)slot)) continue;
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                    LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PRE_ATTACK)) {
                        Entity affected;
                        if (effect.enchanted() != EnchantmentTarget.VICTIM || !effect.matches(context)) continue;
                        switch (effect.affected()) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case ATTACKER: {
                                Entity entity3 = source.getEntity();
                                break;
                            }
                            case DAMAGING_ENTITY: {
                                Entity entity3 = source.getDirectEntity();
                                break;
                            }
                            case VICTIM: {
                                Entity entity3 = affected = target;
                            }
                        }
                        if (affected == null) continue;
                        ((EnchantmentEntityEffect)effect.effect()).apply(serverLevel, entry.getIntValue(), useItem, affected, affected.position());
                    }
                }
            }
        }
        if (itemSource != null && (entity = source.getEntity()) instanceof LivingEntity) {
            ItemEnchantments itemEnchantments;
            entity2 = (LivingEntity)entity;
            EquipmentSlot slot = EquipmentSlot.MAINHAND;
            for (EquipmentSlot slot1 : EquipmentSlot.values()) {
                if (!entity2.getItemBySlot(slot1).equals(itemSource)) continue;
                slot = slot1;
                break;
            }
            if ((itemEnchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), itemSource)) != null && !itemEnchantments.isEmpty()) {
                EnchantedItemInUse useItem = new EnchantedItemInUse(itemSource, slot, entity2);
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    if (!((Enchantment)holder.value()).matchingSlot(slot)) continue;
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                    LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                    for (TargetedConditionalEffect effect : ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PRE_ATTACK)) {
                        Entity affected;
                        if (effect.enchanted() != EnchantmentTarget.ATTACKER || !effect.matches(context)) continue;
                        switch (effect.affected()) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case ATTACKER: {
                                Entity entity4 = source.getEntity();
                                break;
                            }
                            case DAMAGING_ENTITY: {
                                Entity entity4 = source.getDirectEntity();
                                break;
                            }
                            case VICTIM: {
                                Entity entity4 = affected = target;
                            }
                        }
                        if (affected == null) continue;
                        ((EnchantmentEntityEffect)effect.effect()).apply(serverLevel, entry.getIntValue(), useItem, affected, affected.position());
                    }
                }
            }
        }
    }

    public static double increaseMaceRadius(LivingEntity entity, double amount) {
        MutableFloat mutable = new MutableFloat((Number)amount);
        WeaponUtil.smashAttackFunction(entity, EnchiridionEnchantmentEffectComponents.SMASH_AREA, (effect, level) -> mutable.setValue(effect.process(level, entity.getRandom(), mutable.getValue().floatValue())));
        return mutable.getValue().floatValue();
    }

    public static double increaseMaceKnockback(LivingEntity entity, double amount) {
        MutableFloat mutable = new MutableFloat((Number)amount);
        WeaponUtil.smashAttackFunction(entity, EnchiridionEnchantmentEffectComponents.SMASH_KNOCKBACK, (effect, level) -> mutable.setValue(effect.process(level, entity.getRandom(), mutable.getValue().floatValue())));
        return mutable.getValue().floatValue();
    }

    private static void smashAttackFunction(LivingEntity entity, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> effectType, EnchantmentFunction function) {
        Duck_ServerSmashDamageSource duck;
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level = entity.level();
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (entity instanceof Duck_ServerSmashDamageSource && (duck = (Duck_ServerSmashDamageSource)entity).enchiridion$getSmashAttackSource() != null) break block6;
            }
            return;
        }
        LootParams.Builder params = new LootParams.Builder(serverLevel);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)duck.enchiridion$getSmashAttackTarget());
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)duck.enchiridion$getSmashAttackSource());
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)duck.enchiridion$getSmashAttackSource().getEntity());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)duck.enchiridion$getSmashAttackSource().getDirectEntity());
        EquipmentSlot slot = null;
        for (EquipmentSlot slot1 : EquipmentSlot.values()) {
            if (!entity.getItemBySlot(slot1).equals(entity.getWeaponItem())) continue;
            slot = slot1;
            break;
        }
        EquipmentSlot finalSlot = slot;
        for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), entity.getWeaponItem()).entrySet().stream().filter(entry -> !((Enchantment)((Holder)entry.getKey()).value()).getEffects(effectType).isEmpty() && (finalSlot == null || ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(finalSlot))).toList()) {
            int level = entry2.getIntValue();
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(effectType)) {
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level);
                LootContext lootContext = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                if (!effect.matches(lootContext)) continue;
                function.apply((EnchantmentValueEffect)effect.effect(), level);
            }
        }
    }

    @FunctionalInterface
    public static interface EnchantmentFunction {
        public void apply(EnchantmentValueEffect var1, int var2);
    }
}

