/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.block.entity;

import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EnchiridionFrostedIceBlockEntity
extends BlockEntity {
    private float crackChance = 0.333f;
    private int minCrackTime = 60;
    private int maxCrackTime = 120;
    private int minCrackRate = 20;
    private int maxCrackRate = 40;

    public EnchiridionFrostedIceBlockEntity(BlockPos pos, BlockState blockState) {
        super(EnchiridionBlockEntityTypes.FROSTED_ICE, pos, blockState);
    }

    public float getCrackChance() {
        return this.crackChance;
    }

    public int getMinCrackTime() {
        return this.minCrackTime;
    }

    public int getMaxCrackTime() {
        return this.maxCrackTime;
    }

    public int getMinCrackRate() {
        return this.minCrackRate;
    }

    public int getMaxCrackRate() {
        return this.maxCrackRate;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.crackChance = Math.clamp(tag.getFloat("crack_chance"), 0.0f, 1.0f);
        this.minCrackTime = Math.max(1, tag.getInt("min_crack_time"));
        this.maxCrackTime = Math.max(1, tag.getInt("max_crack_time"));
        this.minCrackRate = Math.max(1, tag.getInt("min_crack_rate"));
        this.maxCrackRate = Math.max(1, tag.getInt("max_crack_rate"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putFloat("crack_chance", this.crackChance);
        tag.putInt("min_crack_time", this.minCrackTime);
        tag.putInt("max_crack_time", this.maxCrackTime);
        tag.putInt("min_crack_rate", this.minCrackRate);
        tag.putInt("max_crack_rate", this.maxCrackRate);
    }
}

