/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.screen.recipebook;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.mixin.client.Accessor_OverlayRecipeComponent;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public class OverlaySiphoningRecipeComponent
extends OverlayRecipeComponent {
    public void init(@NotNull Minecraft minecraft, @NotNull RecipeCollection collection, int x, int y, int width, int height, float buttonWidth) {
        super.init(minecraft, collection, x, y, width, height, buttonWidth);
        if (minecraft.player == null) {
            return;
        }
        boolean flag = minecraft.player.getRecipeBook().isFiltering((RecipeBookMenu)minecraft.player.containerMenu);
        List list = collection.getDisplayRecipes(true);
        List list1 = flag ? Collections.emptyList() : collection.getDisplayRecipes(false);
        int i = list.size();
        int j = i + list1.size();
        int k = j <= 16 ? 4 : 5;
        ((Accessor_OverlayRecipeComponent)((Object)this)).enchiridion$getRecipeButtons().clear();
        for (int i1 = 0; i1 < j; ++i1) {
            boolean flag1 = i1 < i;
            RecipeHolder recipeholder = flag1 ? (RecipeHolder)list.get(i1) : (RecipeHolder)list1.get(i1 - i);
            int buttonX = ((Accessor_OverlayRecipeComponent)((Object)this)).enchiridion$getX() + 4 + 25 * (i1 % k);
            int buttonY = ((Accessor_OverlayRecipeComponent)((Object)this)).enchiridion$getY() + 5 + 25 * (i1 / k);
            ((Accessor_OverlayRecipeComponent)((Object)this)).enchiridion$getRecipeButtons().add(new RecipeButton(buttonX, buttonY, recipeholder, flag1));
        }
    }

    public class RecipeButton
    extends OverlayRecipeComponent.OverlayRecipeButton {
        static final ResourceLocation CRAFTING_OVERLAY_HIGHLIGHTED_SPRITE = Enchiridion.id("recipe_book/siphoning_overlay_highlighted");
        static final ResourceLocation CRAFTING_OVERLAY_SPRITE = Enchiridion.id("recipe_book/siphoning_overlay");
        static final ResourceLocation CRAFTING_OVERLAY_DISABLED_HIGHLIGHTED_SPRITE = Enchiridion.id("recipe_book/siphoning_overlay_disabled_highlighted");
        static final ResourceLocation CRAFTING_OVERLAY_DISABLED_SPRITE = Enchiridion.id("recipe_book/siphoning_overlay_disabled");
        private final RecipeHolder<?> recipe;
        private final boolean isCraftable;

        public RecipeButton(int x, int y, RecipeHolder<?> recipe, boolean isCraftable) {
            super((OverlayRecipeComponent)OverlaySiphoningRecipeComponent.this, x, y, recipe, isCraftable);
            this.recipe = recipe;
            this.isCraftable = isCraftable;
        }

        public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            SiphoningRecipe siphoningRecipe;
            OverlayRecipeComponent.OverlayRecipeButton.Pos pos2;
            ResourceLocation resourcelocation = this.isCraftable ? (this.isHoveredOrFocused() ? CRAFTING_OVERLAY_HIGHLIGHTED_SPRITE : CRAFTING_OVERLAY_SPRITE) : (this.isHoveredOrFocused() ? CRAFTING_OVERLAY_DISABLED_HIGHLIGHTED_SPRITE : CRAFTING_OVERLAY_DISABLED_SPRITE);
            guiGraphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)(this.getX() + 2), (double)(this.getY() + 2), 150.0);
            for (OverlayRecipeComponent.OverlayRecipeButton.Pos pos2 : this.ingredientPos) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((double)pos2.x, (double)pos2.y, 0.0);
                guiGraphics.pose().scale(0.375f, 0.375f, 1.0f);
                guiGraphics.pose().translate(-8.0, -8.0, 0.0);
                if (pos2.ingredients.length > 0) {
                    ItemStack stack = pos2.ingredients[Mth.floor((float)(((Accessor_OverlayRecipeComponent)((Object)OverlaySiphoningRecipeComponent.this)).enchiridion$getTime() / 30.0f)) % pos2.ingredients.length];
                    guiGraphics.renderItem(stack, 0, 0);
                }
                guiGraphics.pose().popPose();
            }
            pos2 = this.recipe.value();
            if (pos2 instanceof SiphoningRecipe && (siphoningRecipe = (SiphoningRecipe)pos2).getEnchantments().size() == 1 && siphoningRecipe.getEnchantments().values().stream().flatMap(enchantments -> enchantments.entrySet().stream()).toList().size() == 1) {
                guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
                guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
                int level = siphoningRecipe.getEnchantments().values().stream().flatMap(enchantments -> enchantments.entrySet().stream()).findFirst().map(Object2IntMap.Entry::getIntValue).orElse(0);
                ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)("enchantment.level." + level)).getVisualOrderText()).renderText(Minecraft.getInstance().font, 0, 0, guiGraphics.pose().last().pose(), guiGraphics.bufferSource());
            }
            guiGraphics.pose().popPose();
        }

        protected void calculateIngredientsPositions(RecipeHolder<?> recipe) {
            SiphoningRecipe siphoningRecipe;
            List supportedItems;
            NonNullList ingredients = recipe.value().getIngredients();
            for (int i = 0; i < ingredients.size(); ++i) {
                this.ingredientPos.add(new OverlayRecipeComponent.OverlayRecipeButton.Pos((OverlayRecipeComponent.OverlayRecipeButton)this, 6 + i * 8, 7, ((Ingredient)ingredients.get(i)).getItems()));
            }
            Recipe recipe2 = recipe.value();
            if (recipe2 instanceof SiphoningRecipe && !(supportedItems = (siphoningRecipe = (SiphoningRecipe)recipe2).getEnchantments().entrySet().stream().flatMap(entry -> ((ItemEnchantments)entry.getValue()).entrySet().stream().flatMap(entry1 -> ((Enchantment)((Holder)entry1.getKey()).value()).getSupportedItems().stream())).toList()).isEmpty()) {
                Ingredient enchantableIngredient = Ingredient.of(Stream.concat(BuiltInRegistries.ITEM.getTag(EnchiridionTags.ItemTags.STORED_ENCHANTABLES).stream().flatMap(named -> named.stream().map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance())), supportedItems.stream().filter(Holder::isBound).map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance())));
                this.ingredientPos.add(new OverlayRecipeComponent.OverlayRecipeButton.Pos((OverlayRecipeComponent.OverlayRecipeButton)this, 10, 14, enchantableIngredient.getItems()));
            }
        }
    }
}

