/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.enchiridion.api.registry.EnchiridionDamageTypes;
import house.greenhouse.enchiridion.client.sound.WhirlpoolLoopSoundInstance;
import house.greenhouse.enchiridion.client.util.ClientEntityUtil;
import house.greenhouse.enchiridion.duck.Duck_Whirlpool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Whirlpool
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TARGET_WIDTH = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TARGET_HEIGHT = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SUMMON_SPEED = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> SHOULD_DISPERSE = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(Whirlpool.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private final Object2IntMap<LivingEntity> affectedEntityTimer = new Object2IntOpenHashMap();
    private int lifetime = 80;
    private float damageAmount = 4.0f;
    private Entity cachedOwner;
    private int enchantmentLevel;
    private LootItemCondition disperseCondition;
    private boolean isDispersing = false;
    private boolean hasInitializedSound = false;

    public Whirlpool(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (this.isDispersing || this.shouldDisperse() || this.tickCount > this.lifetime) {
            if ((double)this.getCurrentWidth() < 0.01 && (double)this.getCurrentHeight() < 0.01) {
                this.discard();
                return;
            }
            if (!this.isDispersing) {
                this.isDispersing = true;
            }
        }
        if (this.getOwner() != null) {
            ((Duck_Whirlpool)this.getOwner()).enchiridion$setWhirlpoolPercentage(Math.max(this.getCurrentWidth() / this.getTargetWidth(), this.getCurrentHeight() / this.getTargetHeight()));
        }
        if (this.level().isClientSide) {
            this.refreshDimensions();
            if (!this.hasInitializedSound) {
                WhirlpoolLoopSoundInstance.start(this);
                this.hasInitializedSound = true;
            }
            return;
        }
        float width = this.getCurrentWidth();
        float height = this.getCurrentHeight();
        if (this.isDispersing && (double)width > 0.01 || width < this.getTargetWidth()) {
            this.setCurrentWidth(width += this.getTargetWidth() * (this.isDispersing ? -this.getSummonSpeed() : this.getSummonSpeed()));
        }
        if (this.isDispersing && (double)height > 0.01 || height < this.getTargetHeight()) {
            this.setCurrentHeight(height += this.getTargetHeight() * (this.isDispersing ? -this.getSummonSpeed() : this.getSummonSpeed()));
        }
        if (this.getOwnerUUID() != null && this.getOwner() == null || this.getOwner() != null && (!this.getOwner().isAlive() || this.getOwner().isRemoved())) {
            this.setToDisperse();
        }
        this.refreshDimensions();
        for (Object2IntMap.Entry entry2 : this.affectedEntityTimer.object2IntEntrySet()) {
            entry2.setValue(entry2.getIntValue() + 1);
        }
        this.affectedEntityTimer.object2IntEntrySet().removeIf(entry -> entry.getIntValue() > 20);
        if (this.isDispersing ^ height > this.getTargetHeight()) {
            List<LivingEntity> entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox()).stream().filter(entity -> {
                OwnableEntity ownable;
                return this.getOwner() == null || !entity.is(this.getOwner()) && !entity.hasPassenger(this.getOwner()) && (entity.getVehicle() == null || !entity.getVehicle().is(this.getOwner())) && (!(entity instanceof OwnableEntity) || (ownable = (OwnableEntity)entity).getOwner() == null || !ownable.getOwner().is(this.getOwner())) && !entity.isAlliedTo(this.getOwner());
            }).toList();
            for (LivingEntity entity2 : entities) {
                if (this.affectedEntityTimer.containsKey((Object)entity2)) continue;
                if (this.getOwner() != null) {
                    entity2.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(EnchiridionDamageTypes.WHIRLPOOL), (Entity)this, this.getOwner(), entity2.position()), this.damageAmount);
                } else {
                    entity2.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(EnchiridionDamageTypes.WHIRLPOOL)), this.damageAmount);
                }
                this.affectedEntityTimer.put((Object)entity2, 0);
            }
        }
        if (!this.isDispersing && this.getOwner() != null && this.disperseCondition != null) {
            LootParams.Builder params = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.getOwner()).withParameter(LootContextParams.ORIGIN, (Object)this.getOwner().position()).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)this.enchantmentLevel);
            if (this.disperseCondition.test((Object)new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()))) {
                this.setToDisperse();
            }
        } else if (this.getOwner() != null) {
            this.setPos(this.getOwner().position());
        }
    }

    @NotNull
    public AABB makeBoundingBox() {
        return AABB.ofSize((Vec3)this.position().add(0.0, this.getOwner() == null ? 0.0 : this.getOwner().getY(0.5) - this.getOwner().getY(), 0.0), (double)this.getCurrentWidth(), (double)this.getCurrentHeight(), (double)this.getCurrentWidth());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(WIDTH, (Object)Float.valueOf(0.0f));
        builder.define(HEIGHT, (Object)Float.valueOf(0.0f));
        builder.define(TARGET_WIDTH, (Object)Float.valueOf(0.0f));
        builder.define(TARGET_HEIGHT, (Object)Float.valueOf(0.0f));
        builder.define(SUMMON_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(SHOULD_DISPERSE, (Object)false);
        builder.define(OWNER, Optional.empty());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setCurrentWidth(compound.getFloat("width"));
        if (compound.contains("target_width")) {
            this.setTargetWidth(compound.getFloat("target_width"));
        }
        this.setCurrentHeight(compound.getFloat("height"));
        if (compound.contains("target_height")) {
            this.setTargetHeight(compound.getFloat("target_height"));
        }
        if (compound.contains("summon_speed")) {
            this.setSummonSpeed(compound.getFloat("summon_speed"));
        }
        if (compound.contains("age")) {
            this.tickCount = compound.getInt("age");
        }
        if (compound.contains("lifetime")) {
            this.lifetime = compound.getInt("lifetime");
        }
        this.entityData.set(SHOULD_DISPERSE, (Object)compound.getBoolean("should_disperse"));
        this.isDispersing = compound.getBoolean("is_dispersing");
        if (compound.contains("damage_amount")) {
            this.damageAmount = compound.getFloat("damage_amount");
        }
        if (!this.level().isClientSide && compound.contains("disperse_condition")) {
            this.disperseCondition = (LootItemCondition)((Pair)LootItemCondition.DIRECT_CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.level().registryAccess()), (Object)compound.get("disperse_condition")).getOrThrow()).getFirst();
        }
        if (compound.contains("owner")) {
            this.setOwner(compound.getUUID("owner"));
        }
        if (compound.contains("enchantment_level")) {
            this.enchantmentLevel = compound.getInt("enchantment_level");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("width", this.getCurrentWidth());
        compound.putFloat("target_width", this.getTargetWidth());
        compound.putFloat("height", this.getCurrentHeight());
        compound.putFloat("target_height", this.getTargetHeight());
        compound.putFloat("summon_speed", this.getSummonSpeed());
        compound.putInt("age", this.tickCount);
        compound.putInt("lifetime", this.lifetime);
        compound.putFloat("damage_amount", this.damageAmount);
        compound.putBoolean("should_disperse", this.shouldDisperse());
        compound.putBoolean("is_dispersing", this.isDispersing);
        if (!this.level().isClientSide && this.disperseCondition != null) {
            compound.put("disperse_condition", (Tag)LootItemCondition.DIRECT_CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.level().registryAccess()), (Object)this.disperseCondition).getOrThrow());
        }
        if (this.getOwnerUUID() != null) {
            compound.putUUID("owner", this.getOwnerUUID());
        }
        if (this.enchantmentLevel > 0) {
            compound.putInt("enchantment_level", this.enchantmentLevel);
        }
    }

    public float getCurrentWidth() {
        return this.getCurrentWidth(0.0f);
    }

    public void setCurrentWidth(float value) {
        this.entityData.set(WIDTH, (Object)Float.valueOf(value));
    }

    public float getCurrentWidth(float tickOffset) {
        boolean decreasing = this.getTargetWidth() < ((Float)this.entityData.get(WIDTH)).floatValue();
        float value = ((Float)this.entityData.get(WIDTH)).floatValue() + (float)(decreasing ? -1 : 1) * this.getSummonSpeed() * tickOffset;
        return decreasing ? Math.max(value, this.getTargetWidth()) : Math.min(value, this.getTargetWidth());
    }

    public float getTargetWidth() {
        return ((Float)this.entityData.get(TARGET_WIDTH)).floatValue();
    }

    public void setTargetWidth(float value) {
        this.entityData.set(TARGET_WIDTH, (Object)Float.valueOf(value));
    }

    public float getCurrentHeight() {
        return this.getCurrentHeight(0.0f);
    }

    public void setCurrentHeight(float value) {
        this.entityData.set(HEIGHT, (Object)Float.valueOf(value));
    }

    public float getCurrentHeight(float tickOffset) {
        boolean decreasing = this.getTargetHeight() < ((Float)this.entityData.get(HEIGHT)).floatValue();
        float value = ((Float)this.entityData.get(HEIGHT)).floatValue() + (float)(decreasing ? -1 : 1) * this.getSummonSpeed() * tickOffset;
        return decreasing ? Math.max(value, this.getTargetHeight()) : Math.min(value, this.getTargetHeight());
    }

    public float getTargetHeight() {
        return ((Float)this.entityData.get(TARGET_HEIGHT)).floatValue();
    }

    public void setTargetHeight(float value) {
        this.entityData.set(TARGET_HEIGHT, (Object)Float.valueOf(value));
    }

    private float getSummonSpeed() {
        return ((Float)this.entityData.get(SUMMON_SPEED)).floatValue();
    }

    public void setSummonSpeed(float value) {
        this.entityData.set(SUMMON_SPEED, (Object)Float.valueOf(value));
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public void setDamageAmount(float value) {
        this.damageAmount = value;
    }

    public void setDisperseCondition(LootItemCondition value) {
        this.disperseCondition = value;
    }

    public void setEnchantmentLevel(int enchantmentLevel) {
        this.enchantmentLevel = enchantmentLevel;
    }

    private boolean shouldDisperse() {
        return (Boolean)this.entityData.get(SHOULD_DISPERSE);
    }

    private void setToDisperse() {
        this.entityData.set(SHOULD_DISPERSE, (Object)true);
    }

    @Nullable
    private UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER)).orElse(null);
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.getOwnerUUID() != null) {
            Level var2 = this.level();
            if (var2 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var2;
                this.cachedOwner = serverlevel.getEntity(this.getOwnerUUID());
                if (this.cachedOwner != null) {
                    ((Duck_Whirlpool)this.cachedOwner).enchiridion$setConnectedWhirlpool(this);
                }
                return this.cachedOwner;
            }
            if (this.level().isClientSide()) {
                this.cachedOwner = ClientEntityUtil.getEntityFromUUID(this.level(), this.getOwnerUUID());
                if (this.cachedOwner != null) {
                    ((Duck_Whirlpool)this.cachedOwner).enchiridion$setConnectedWhirlpool(this);
                }
                return this.cachedOwner;
            }
        }
        return null;
    }

    private void setOwner(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public void setOwner(Entity entity) {
        this.entityData.set(OWNER, Optional.of(entity.getUUID()));
    }

    public boolean canBeHitByProjectile() {
        return true;
    }
}

