/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.integration.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Widget;
import house.greenhouse.enchiridion.integration.emi.EnchiridionRecipeCategories;
import house.greenhouse.enchiridion.integration.emi.recipe.EmiSiphoningRecipe;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.RecipeHolder;

public class SiphoningRecipeHandler
implements StandardRecipeHandler<SiphoningMenu> {
    public List<Slot> getInputSources(SiphoningMenu menu) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            list.add(menu.getSlot(i));
        }
        for (int i = invStart = 3; i < invStart + 36; ++i) {
            list.add(menu.getSlot(i));
        }
        return list;
    }

    public List<Slot> getCraftingSlots(SiphoningMenu menu) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            list.add(menu.getSlot(i));
        }
        return list;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<SiphoningMenu> context) {
        if (recipe instanceof EmiSiphoningRecipe) {
            EmiSiphoningRecipe siphoningRecipe = (EmiSiphoningRecipe)recipe;
            return (Minecraft.getInstance().level != null && recipe.getId() != null && Minecraft.getInstance().level.getRecipeManager().byKey(recipe.getId()).map(recipeHolder -> ((SiphoningMenu)context.getScreenHandler()).recipeMatches((RecipeHolder<SiphoningRecipe>)recipeHolder)).orElse(false) != false && ((SiphoningMenu)context.getScreenHandler()).isSiphoning() || ((SiphoningMenu)context.getScreenHandler()).getExperience() >= siphoningRecipe.getExperienceCost()) && super.canCraft(recipe, context);
        }
        return false;
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<SiphoningMenu> context) {
        if (recipe instanceof EmiSiphoningRecipe) {
            EmiSiphoningRecipe siphoningRecipe = (EmiSiphoningRecipe)recipe;
            if (!super.canCraft(recipe, context)) {
                return super.getTooltip(recipe, context);
            }
            if (!(Minecraft.getInstance().level != null && recipe.getId() != null && Minecraft.getInstance().level.getRecipeManager().byKey(recipe.getId()).map(recipeHolder -> ((SiphoningMenu)context.getScreenHandler()).recipeMatches((RecipeHolder<SiphoningRecipe>)recipeHolder)).orElse(false).booleanValue() && ((SiphoningMenu)context.getScreenHandler()).isSiphoning() || ((SiphoningMenu)context.getScreenHandler()).getExperience() >= siphoningRecipe.getExperienceCost())) {
                return List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"container.enchiridion.siphon.experience_points.more").getVisualOrderText()));
            }
        }
        return super.getTooltip(recipe, context);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<SiphoningMenu> context, List<Widget> widgets, GuiGraphics draw) {
        super.render(recipe, context, widgets, draw);
        if (recipe instanceof EmiSiphoningRecipe) {
            EmiSiphoningRecipe siphoningRecipe = (EmiSiphoningRecipe)recipe;
            if (!(Minecraft.getInstance().level != null && recipe.getId() != null && Minecraft.getInstance().level.getRecipeManager().byKey(recipe.getId()).map(recipeHolder -> ((SiphoningMenu)context.getScreenHandler()).recipeMatches((RecipeHolder<SiphoningRecipe>)recipeHolder)).orElse(false).booleanValue() && ((SiphoningMenu)context.getScreenHandler()).isSiphoning() || ((SiphoningMenu)context.getScreenHandler()).getExperience() >= siphoningRecipe.getExperienceCost())) {
                draw.fill(11, 51, 27, 55, 0x44FF0000);
            }
        }
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == EnchiridionRecipeCategories.SIPHONING && recipe.supportsRecipeTree();
    }
}

