/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.integration.emi.EnchiridionRecipeCategories;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class EmiSiphoningRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = Enchiridion.id("textures/gui/container/siphoning_table.png");
    private static final ResourceLocation EXPERIENCE_BAR_SPRITE = Enchiridion.id("textures/gui/sprites/container/siphoning_table/experience_bar.png");
    private static final ResourceLocation SIPHON_INDICATOR_SPRITE = Enchiridion.id("textures/gui/sprites/container/siphoning_table/siphon_indicator.png");
    private static final ResourceLocation SIPHONING_PROGRESS_SPRITE = Enchiridion.id("textures/gui/sprites/container/siphoning_table/siphoning_progress.png");
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final EmiStack output;
    private final int experienceCost;
    private final int time;

    public EmiSiphoningRecipe(ResourceLocation id, List<EmiIngredient> inputs, EmiStack output, int experienceCost, int time) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.experienceCost = experienceCost;
        this.time = time;
    }

    public EmiRecipeCategory getCategory() {
        return EnchiridionRecipeCategories.SIPHONING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    public int getTime() {
        return this.time;
    }

    public int getDisplayWidth() {
        return 109;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 109, 56, 34, 15);
        widgets.addTexture(EXPERIENCE_BAR_SPRITE, 11, 51, Mth.ceil((float)((float)this.experienceCost / 15.0f * 16.0f)), 4, 0, 0, Mth.ceil((float)((float)this.experienceCost / 15.0f * 16.0f)), 4, 16, 4);
        widgets.addTooltip(List.of(ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.composite((FormattedCharSequence)Component.translatable((String)"emi.cooking.experience", (Object[])new Object[]{this.experienceCost}).getVisualOrderText())), ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.composite((FormattedCharSequence)Component.translatable((String)"container.enchiridion.siphon.sculk_catalyst", (Object[])new Object[]{this.experienceCost}).getVisualOrderText()))), 11, 51, 16, 4);
        widgets.addAnimatedTexture(SIPHON_INDICATOR_SPRITE, 11, 20, 16, 12, 0, 0, 16, 12, 16, 12, 1400, false, false, false);
        widgets.addAnimatedTexture(SIPHONING_PROGRESS_SPRITE, 33, 35, 43, 14, 0, 0, 43, 14, 43, 14, 20000, true, false, false).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{this.time / 20}).getVisualOrderText())));
        for (int i = 0; i < 2; ++i) {
            this.addSlot(widgets, this.inputs.get(i), 1 + i * 18, 1);
        }
        this.addSlot(widgets, this.inputs.get(2), 10, 33);
        this.addSlot(widgets, (EmiIngredient)this.output, 86, 33).recipeContext((EmiRecipe)this);
    }

    private SlotWidget addSlot(WidgetHolder widgets, EmiIngredient ingredient, int x, int y) {
        return (SlotWidget)widgets.add((Widget)new SlotWidget(this, ingredient, x, y){

            public void drawBackground(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            }
        });
    }
}

