/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.menu;

import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.menu.recipebook.EnchiridionRecipeBook;
import house.greenhouse.enchiridion.menu.recipebook.SiphoningPlaceRecipe;
import house.greenhouse.enchiridion.menu.slot.SiphoningResultSlot;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionBlocks;
import house.greenhouse.enchiridion.registry.EnchiridionMenuTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SiphoningMenu
extends RecipeBookMenu<SiphoningInput, SiphoningRecipe> {
    private final SiphoningTableBlockEntity blockEntity;

    public SiphoningMenu(int containerId, Inventory playerInventory, BlockPos pos) {
        this(containerId, playerInventory, SiphoningMenu.getBlockEntity(playerInventory, pos));
    }

    public SiphoningMenu(int containerId, Inventory playerInventory, SiphoningTableBlockEntity blockEntity) {
        super(EnchiridionMenuTypes.SIPHONING, containerId);
        this.blockEntity = blockEntity;
        this.addSlot(new Slot((Container)blockEntity, 0, 36, 17));
        this.addSlot(new Slot((Container)blockEntity, 1, 54, 17));
        this.addSlot(new Slot(this, (Container)blockEntity, 2, 45, 48){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.is(EnchiridionTags.ItemTags.INCLUSIVE_ENCHANTABLES);
            }
        });
        this.addSlot(new SiphoningResultSlot(playerInventory.player, (Container)blockEntity, 3, 121, 49));
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
    }

    private static SiphoningTableBlockEntity getBlockEntity(Inventory playerInventory, BlockPos data) {
        Optional tileAtPos = playerInventory.player.level().getBlockEntity(data, EnchiridionBlockEntityTypes.SIPHONING_TABLE);
        if (tileAtPos.isPresent()) {
            return (SiphoningTableBlockEntity)((Object)tileAtPos.get());
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public SiphoningTableBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean isSiphoning() {
        return this.blockEntity.isSiphoning();
    }

    public int getEnchantingProgressFill() {
        return Mth.ceil((float)((float)this.blockEntity.getEnchantTime() / (float)this.blockEntity.getEnchantTimeTotal() * 43.0f));
    }

    public int getExperience() {
        return this.blockEntity.getExperience();
    }

    public int getExperienceBarFill() {
        return Mth.ceil((float)((float)this.getExperience() / 15.0f * 16.0f));
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.blockEntity.getLevel() == null) {
            return false;
        }
        return SiphoningMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)EnchiridionBlocks.SIPHONING_TABLE);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 3) {
                if (!this.moveItemStackTo(slotStack, 4, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= 0 && index < 3 ? !this.moveItemStackTo(slotStack, 4, 38, true) : (slotStack.is(EnchiridionTags.ItemTags.INCLUSIVE_ENCHANTABLES) ? !this.moveItemStackTo(slotStack, 2, 3, false) : (this.isValidRecipeItem(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : !slotStack.isEmpty() && !this.moveItemStackTo(slotStack, 0, 1, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return stack;
    }

    private boolean isValidRecipeItem(ItemStack stack) {
        if (this.blockEntity.getLevel() == null) {
            return false;
        }
        return this.blockEntity.getLevel().getRecipeManager().getAllRecipesFor(EnchiridionRecipeTypes.SIPHONING).stream().filter(holder -> ((SiphoningRecipe)holder.value()).getIngredients().size() > 1 && ((Ingredient)((SiphoningRecipe)holder.value()).getIngredients().getFirst()).test(this.blockEntity.getItem(0))).anyMatch(holder -> ((Ingredient)((SiphoningRecipe)holder.value()).getIngredients().getLast()).test(this.blockEntity.getItem(1))) || stack.is(Items.LAPIS_LAZULI);
    }

    public void fillCraftSlotsStackedContents(@NotNull StackedContents helper) {
        for (int i = 0; i < 3; ++i) {
            helper.accountStack(this.blockEntity.getItem(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 4; ++i) {
            this.blockEntity.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean recipeMatches(@NotNull RecipeHolder<SiphoningRecipe> recipe) {
        if (this.blockEntity.getLevel() == null) {
            return false;
        }
        return ((SiphoningRecipe)recipe.value()).matches(new SiphoningInput((Container)this.blockEntity), this.blockEntity.getLevel());
    }

    public int getResultSlotIndex() {
        return 3;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 4;
    }

    @NotNull
    public RecipeBookType getRecipeBookType() {
        return EnchiridionRecipeBook.SIPHONING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlacement(boolean placeAll, @NotNull RecipeHolder<?> recipe, @NotNull ServerPlayer player) {
        RecipeHolder<?> recipeholder = recipe;
        this.beginPlacingRecipe();
        try {
            new SiphoningPlaceRecipe(this).recipeClicked(player, recipeholder, placeAll);
        }
        finally {
            this.finishPlacingRecipe(recipe);
        }
    }

    public boolean shouldMoveToInventory(int slotIndex) {
        return true;
    }
}

