/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.menu.recipebook;

import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.mixin.Accessor_StackedContentsRecipePicker;
import house.greenhouse.enchiridion.mixin.Invoker_StackedContentsRecipePicker;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningStackedContents
extends StackedContents {
    private final SiphoningMenu menu;
    @Nullable
    public Recipe<?> currentRecipe = null;

    public SiphoningStackedContents(SiphoningMenu menu) {
        this.menu = menu;
    }

    public RecipePicker createRecipePicker(Recipe<?> recipe) {
        return new RecipePicker(recipe);
    }

    public boolean canCraft(@NotNull Recipe<?> recipe, @Nullable IntList stackingIndexList, int amount) {
        if (recipe instanceof SiphoningRecipe) {
            SiphoningRecipe siphoningRecipe = (SiphoningRecipe)recipe;
            if ((this.currentRecipe == null || this.currentRecipe != recipe) && siphoningRecipe.getExperienceCost() > this.menu.getExperience()) {
                return false;
            }
        }
        return new RecipePicker(recipe).tryPick(amount, stackingIndexList);
    }

    public int getBiggestCraftableStack(RecipeHolder<?> recipe, int amount, @Nullable IntList stackingIndexList) {
        return new RecipePicker(recipe.value()).tryPickAll(amount, stackingIndexList);
    }

    public class RecipePicker
    extends StackedContents.RecipePicker {
        private final Int2IntMap stackCountRequirements;

        public RecipePicker(Recipe<?> recipe) {
            super((StackedContents)SiphoningStackedContents.this, recipe);
            this.stackCountRequirements = new Int2IntArrayMap();
            if (recipe instanceof SiphoningRecipe) {
                SiphoningRecipe siphoningRecipe = (SiphoningRecipe)recipe;
                Accessor_StackedContentsRecipePicker accessor = (Accessor_StackedContentsRecipePicker)((Object)this);
                Invoker_StackedContentsRecipePicker invoker = (Invoker_StackedContentsRecipePicker)((Object)this);
                for (int i = 0; i < 2; ++i) {
                    IntListIterator intListIterator = accessor.enchiridion$getIngredients().get(i).getStackingIds().iterator();
                    while (intListIterator.hasNext()) {
                        int id = (Integer)intListIterator.next();
                        this.stackCountRequirements.put(id, siphoningRecipe.getIngredientsWithAmounts().get(i).amount());
                    }
                }
                Optional<List> supportedItems = siphoningRecipe.getEnchantments().entrySet().stream().sorted(Comparator.comparingInt(value -> {
                    int size = ((ItemEnchantments)value.getValue()).entrySet().size();
                    if (size < 1) {
                        return Integer.MAX_VALUE;
                    }
                    return size;
                })).flatMap(entry -> ((ItemEnchantments)entry.getValue()).entrySet().stream().map(entry1 -> ((Enchantment)((Holder)entry1.getKey()).value()).getSupportedItems())).map(holders -> holders.stream().toList()).reduce((holders, otherHolders) -> Stream.concat(holders.stream().filter(otherHolders::contains), otherHolders.stream().filter(holders::contains)).toList());
                Ingredient extractIngredient = Ingredient.of(Stream.concat(supportedItems.stream().flatMap(holders -> holders.stream().map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance())), BuiltInRegistries.ITEM.getTag(EnchiridionTags.ItemTags.STORED_ENCHANTABLES).map(named -> named.stream().map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance())).orElse(Stream.of(new ItemStack[0]))));
                extractIngredient.getItems();
                extractIngredient.getStackingIds();
                accessor.enchiridion$getIngredients().add(extractIngredient);
                accessor.enchiridion$getIngredients().removeIf(Ingredient::isEmpty);
                accessor.enchiridion$setIngredientCount(accessor.enchiridion$getIngredients().size());
                accessor.enchiridion$setItems(invoker.enchiridion$invokeGetUniqueAvailableIngredientItems());
                accessor.enchiridion$setItemCount(accessor.enchiridion$getItems().length);
                accessor.enchiridion$setData(new BitSet(accessor.enchiridion$getIngredientCount() + accessor.enchiridion$getItemCount() + accessor.enchiridion$getIngredientCount() + accessor.enchiridion$getIngredientCount() * accessor.enchiridion$getItemCount()));
                for (int i = 0; i < accessor.enchiridion$getIngredients().size(); ++i) {
                    IntList intlist = accessor.enchiridion$getIngredients().get(i).getStackingIds();
                    for (int j = 0; j < accessor.enchiridion$getItemCount(); ++j) {
                        if (!intlist.contains(accessor.enchiridion$getItems()[j])) continue;
                        int bitIndex = invoker.enchiridion$invokeGetIndex(true, j, i);
                        accessor.enchiridion$getData().set(bitIndex);
                    }
                }
            }
        }

        public int getItemCount(int itemIndex) {
            return this.stackCountRequirements.getOrDefault(itemIndex, 1);
        }

        public int getItemCount(ItemStack stack) {
            return this.getItemCount(StackedContents.getStackingIndex((ItemStack)stack));
        }

        public boolean isCountItem(int itemIndex) {
            return this.stackCountRequirements.containsKey(itemIndex);
        }

        public boolean hasItemAmount(int originalAmount, int itemIndex) {
            return originalAmount >= this.stackCountRequirements.get(itemIndex);
        }

        public SiphoningStackedContents getOuter() {
            return SiphoningStackedContents.this;
        }
    }
}

