/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionAttributes;
import house.greenhouse.enchiridion.network.serverbound.SyncCurrentSprintDirectionServerboundPacket;
import java.util.Optional;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LocalPlayer.class})
public abstract class Mixin_LocalPlayer
extends LivingEntity {
    @Shadow
    public Input input;

    protected Mixin_LocalPlayer(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean isUnderWater();

    @Shadow
    public abstract boolean isUsingItem();

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/Input;hasForwardImpulse()Z")})
    private boolean enchiridion$allowDirectionalSprinting(boolean original) {
        LocalPlayer thisAsPlayer = (LocalPlayer)this;
        if (!Enchiridion.getHelper().hasSprintDirectionAttachment((Entity)thisAsPlayer)) {
            if (Enchiridion.getHelper().hasCurrentSprintingDirection((Entity)thisAsPlayer)) {
                Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, null);
                Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.empty()));
            }
            return original;
        }
        float impulseRequirement = 1.0E-5f;
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.NORTH) && this.input.forwardImpulse > impulseRequirement) {
            Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, Direction.NORTH);
            Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.of(Direction.NORTH)));
            return true;
        }
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.SOUTH) && this.input.forwardImpulse < -impulseRequirement) {
            Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, Direction.SOUTH);
            Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.of(Direction.SOUTH)));
            return true;
        }
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.EAST) && this.input.leftImpulse < -impulseRequirement) {
            Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, Direction.EAST);
            Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.of(Direction.EAST)));
            return true;
        }
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.WEST) && this.input.leftImpulse > impulseRequirement) {
            Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, Direction.WEST);
            Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.of(Direction.WEST)));
            return true;
        }
        if (Enchiridion.getHelper().hasCurrentSprintingDirection((Entity)thisAsPlayer)) {
            Enchiridion.getHelper().setCurrentSprintingDirection((Entity)thisAsPlayer, null);
            Enchiridion.getHelper().sendServerbound(new SyncCurrentSprintDirectionServerboundPacket(Optional.empty()));
        }
        return false;
    }

    @ModifyReturnValue(method={"hasEnoughImpulseToStartSprinting"}, at={@At(value="RETURN")})
    private boolean enchiridion$modifyImpulseToAllDirections(boolean original) {
        float impulseRequirement;
        LocalPlayer thisAsPlayer = (LocalPlayer)this;
        if (!Enchiridion.getHelper().hasSprintDirectionAttachment((Entity)thisAsPlayer) && this.getAttributeValue(EnchiridionAttributes.USING_ITEM_SPRINT_SPEED) <= 0.0) {
            return original;
        }
        float f = this.isUnderWater() ? 1.0E-5f : (impulseRequirement = this.isUsingItem() && this.getAttributeValue(EnchiridionAttributes.USING_ITEM_SPRINT_SPEED) > 0.0 ? 0.15f : 0.8f);
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.NORTH) && this.input.forwardImpulse > impulseRequirement) {
            return true;
        }
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.EAST) && this.input.leftImpulse < -impulseRequirement) {
            return true;
        }
        if (Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.WEST) && this.input.leftImpulse > impulseRequirement) {
            return true;
        }
        return Enchiridion.getHelper().canSprintInDirection((Entity)thisAsPlayer, Direction.SOUTH) && this.input.forwardImpulse < -impulseRequirement;
    }

    @ModifyExpressionValue(method={"canStartSprinting"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean enchiridion$allowSprintingWhilstUsingItem(boolean original) {
        return original && this.getAttributeValue(EnchiridionAttributes.USING_ITEM_SPRINT_SPEED) <= 0.0;
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean enchiridion$increaseSpeedWhilstUsingItem(boolean original) {
        boolean bl;
        boolean bl2 = bl = this.getAttributeValue(EnchiridionAttributes.USING_ITEM_SPRINT_SPEED) > 0.0;
        if (bl && original) {
            double modifier = (double)0.2f + (this.isSprinting() ? this.getAttributeValue(EnchiridionAttributes.USING_ITEM_SPRINT_SPEED) : 0.0);
            this.input.leftImpulse *= (float)modifier;
            this.input.forwardImpulse *= (float)modifier;
        }
        return !bl && original;
    }
}

