/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.client;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.client.EnchiridionClient;
import house.greenhouse.enchiridion.client.particle.FrostParticle;
import house.greenhouse.enchiridion.client.screen.SiphoningScreen;
import house.greenhouse.enchiridion.client.util.ClientTextUtil;
import house.greenhouse.enchiridion.neoforge.EnchiridionNeoForge;
import house.greenhouse.enchiridion.neoforge.client.platform.EnchiridionClientPlatformHelperNeoForge;
import house.greenhouse.enchiridion.neoforge.mixin.client.Accessor_ItemColors;
import house.greenhouse.enchiridion.registry.EnchiridionMenuTypes;
import house.greenhouse.enchiridion.registry.EnchiridionParticleTypes;
import house.greenhouse.enchiridion.util.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.AttackSweepParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@Mod(value="enchiridion", dist={Dist.CLIENT})
public class EnchiridionNeoForgeClient {
    public EnchiridionNeoForgeClient(IEventBus bus) {
        EnchiridionClient.init(new EnchiridionClientPlatformHelperNeoForge());
        EnchiridionNeoForge.isClient = true;
    }

    @EventBusSubscriber(modid="enchiridion", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onClientSetup(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                event.addPackFinders(Enchiridion.id("resourcepacks/enchanted_books"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.enchiridion.enchanted_books.name"), EnchiridionNeoForge.createSource(true), false, Pack.Position.TOP);
                if (Enchiridion.ENCHANTMENT_DESCRIPTION_MODS.stream().anyMatch(s -> ModList.get().isLoaded(s))) {
                    event.addPackFinders(Enchiridion.id("resourcepacks/enchantment_descriptions_compat"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.enchiridion.enchantment_descriptions_compat.name"), EnchiridionNeoForge.createSource(true), false, Pack.Position.TOP);
                }
            }
        }

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register(EnchiridionMenuTypes.SIPHONING, SiphoningScreen::new);
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            EnchiridionClient.registerItemColors(itemLike -> ((Accessor_ItemColors)event.getItemColors()).enchiridion$getItemColors().get(itemLike.asItem()), (itemColor, itemLikes) -> event.register(itemColor, (ItemLike[])itemLikes.toArray(ItemLike[]::new)));
        }

        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            EnchiridionClient.registerEntityModelLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            EnchiridionClient.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
            EnchiridionClient.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)EnchiridionParticleTypes.ENCHANTED_SWEEP_ATTACK, AttackSweepParticle.Provider::new);
            event.registerSpriteSet((ParticleType)EnchiridionParticleTypes.FROST, FrostParticle.Provider::new);
        }
    }

    @EventBusSubscriber(modid="enchiridion", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class GameEvents {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void modifyTooltip(ItemTooltipEvent event) {
            TextUtil.modifyEnchantmentTooltips(event.getItemStack(), event.getContext(), event.getFlags(), event.getToolTip());
        }

        @SubscribeEvent
        public static void onClientChatReceived(ClientChatReceivedEvent event) {
            Component component = ClientTextUtil.modifyEnchantCommandMessage(event.getMessage());
            if (component != null && event.isSystem()) {
                event.setMessage(component);
            }
        }

        @SubscribeEvent
        public static void onEntityTick(EntityTickEvent.Post event) {
            Entity entity = event.getEntity();
            if (entity.level().isClientSide() && entity.isAlive()) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.cameraEntity == entity && minecraft.options.getCameraType().isFirstPerson()) {
                    return;
                }
                if (Enchiridion.getHelper().isFrozenByEnchantment(entity) && !entity.isInPowderSnow && entity.tickCount % 8 == 0 && entity.getTicksFrozen() > entity.getTicksRequiredToFreeze()) {
                    for (int i = 0; i < 4; ++i) {
                        double x = entity.getX() + entity.getBoundingBox().getXsize() / 2.0 * entity.getRandom().nextDouble();
                        double y = entity.getY(entity.getRandom().nextDouble());
                        double z = entity.getZ() + entity.getBoundingBox().getZsize() / 2.0 * entity.getRandom().nextDouble();
                        entity.level().addParticle((ParticleOptions)EnchiridionParticleTypes.FROST, x, y, z, entity.getRandom().nextDouble() * 0.025, entity.getRandom().nextDouble() * 0.025, entity.getRandom().nextDouble() * 0.025);
                    }
                }
            }
        }
    }
}

