/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.network.clientbound;

import house.greenhouse.enchiridion.Enchiridion;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record SyncSprintDirectionsClientboundPacket(int entityId, List<Direction> value, boolean remove) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Enchiridion.id("sync_sprint_directions");
    public static final CustomPacketPayload.Type<SyncSprintDirectionsClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, SyncSprintDirectionsClientboundPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncSprintDirectionsClientboundPacket::write, SyncSprintDirectionsClientboundPacket::new);

    public SyncSprintDirectionsClientboundPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), (List)Direction.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buf), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        Direction.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buf, this.value);
        buf.writeBoolean(this.remove);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            if (this.remove) {
                Enchiridion.getHelper().removeSprintDirections(entity);
                return;
            }
            Enchiridion.getHelper().setAbleToSprintInDirection(entity, this.value);
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

