/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import house.greenhouse.enchiridion.util.EnchantmentComparisonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class CreativeTabUtil {
    public static void addSiphoningTableToCreativeMenu(InsertionConsumer consumer) {
        consumer.insert(Items.ENCHANTING_TABLE.getDefaultInstance(), EnchiridionItems.SIPHONING_TABLE.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public static void sortEnchantmentsBasedOnCategory(List<ItemStack> stacks, Consumer<List<ItemStack>> addConsumer, HolderLookup.Provider provider) {
        if (stacks.stream().allMatch(stack -> EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty())) {
            return;
        }
        ArrayList<Pair> indexList = new ArrayList<Pair>(IntStream.range(0, stacks.size()).mapToObj(i -> Pair.of((Object)i, (Object)((ItemStack)stacks.get(i)))).toList());
        List<Item> itemList = indexList.stream().map(pair -> ((ItemStack)pair.getSecond()).getItem()).toList();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(indexList.stream().map(Pair::getSecond).toList());
        stackList.sort((stack, otherStack) -> {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            ItemEnchantments otherEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)otherStack);
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            ItemEnchantmentCategories otherCategories = (ItemEnchantmentCategories)otherStack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            if (stack.getItem() != otherStack.getItem() || enchantments.isEmpty() || otherEnchantments.isEmpty()) {
                return Integer.compare(itemList.indexOf(stack.getItem()), itemList.indexOf(otherStack.getItem()));
            }
            Pair<Holder<Enchantment>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, enchantments, categories);
            Pair<Holder<Enchantment>, Integer> otherEnchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, otherEnchantments, otherCategories);
            int categoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, enchantments, categories)).map(category -> {
                if (!category.isBound()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.value()).priority();
            }).orElse(0);
            int otherCategoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, otherEnchantments, otherCategories)).map(category -> {
                if (!category.isBound()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.value()).priority();
            }).orElse(0);
            if (enchantment != null && otherEnchantment != null && ((Holder)enchantment.getFirst()).equals(otherEnchantment.getFirst())) {
                return Integer.compare((Integer)enchantment.getSecond(), (Integer)otherEnchantment.getSecond());
            }
            if (categoryPriority == otherCategoryPriority && enchantment != null && otherEnchantment != null) {
                return EnchantmentComparisonUtil.compareEnchantmentNames((Holder<Enchantment>)((Holder)enchantment.getFirst()), (Holder<Enchantment>)((Holder)otherEnchantment.getFirst()));
            }
            return Integer.compare(otherCategoryPriority, categoryPriority);
        });
        addConsumer.accept(stackList);
    }

    public static interface InsertionConsumer {
        public void insert(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);
    }
}

