/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentCategories;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCategoryUtil {
    public static void updateCategories(ItemStack stack, Consumer<ItemEnchantmentCategories.Mutable> consumer) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories()) {
            return;
        }
        ItemEnchantmentCategories.Mutable mutable = new ItemEnchantmentCategories.Mutable((ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY));
        consumer.accept(mutable);
        ItemEnchantmentCategories newCategories = mutable.toImmutable();
        if (newCategories.isEmpty()) {
            stack.remove(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES);
        } else {
            stack.set(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)newCategories);
        }
    }

    public static void enchantFromCategory(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> enchantments, Holder<EnchantmentCategory> category) {
        EnchantmentCategoryUtil.enchantFromCategories(random, stack, level, enchantments, List.of(category));
    }

    public static void enchantFromCategories(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> enchantments, List<Holder<EnchantmentCategory>> categories) {
        EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)stack, (int)level, Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() ? enchantments : enchantments.filter(enchantmentHolder -> categories.stream().anyMatch(holder -> holder.isBound() && ((EnchantmentCategory)holder.value()).acceptedEnchantments().contains(enchantmentHolder))));
    }

    public static void categoriseEnchantmentsOnItem(ItemStack stack) {
        DataComponentType<ItemEnchantments> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        EnchantmentCategoryUtil.categoriseEnchantmentsOnItem((ItemEnchantments)stack.getOrDefault(enchantmentComponent, (Object)ItemEnchantments.EMPTY), stack, enchantmentComponent);
    }

    public static void categoriseEnchantmentsOnItem(ItemEnchantments enchantments, ItemStack stack, DataComponentType<ItemEnchantments> componentType) {
        if (enchantments.isEmpty() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories()) {
            return;
        }
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
        ArrayList<Holder<Enchantment>> missingEnchantments = new ArrayList<Holder<Enchantment>>(enchantments.keySet());
        if (!categories.isEmpty()) {
            missingEnchantments.removeIf(enchantment -> {
                Holder<EnchantmentCategory> category = categories.findFirstCategory((Holder<Enchantment>)enchantment);
                return category == null || !category.isBound() || !category.is(EnchiridionEnchantmentCategories.UNCATEGORISED) || category.is(EnchiridionEnchantmentCategories.UNCATEGORISED) && ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment);
            });
        }
        if (missingEnchantments.isEmpty()) {
            return;
        }
        if (componentType == DataComponents.STORED_ENCHANTMENTS) {
            EnchantmentCategoryUtil.categoriseStoredEnchantmentsOnItem(enchantments, stack, missingEnchantments);
            return;
        }
        EnchantmentCategoryUtil.updateCategories(stack, mutable -> missingEnchantments.forEach(enchantment -> {
            Optional<Holder.Reference<EnchantmentCategory>> reference = EnchantmentCategoryUtil.getOptionalFirstEnchantmentCategory((HolderLookup.Provider)Enchiridion.getHelper().getRegistryAccess(), (Holder<Enchantment>)enchantment);
            if (reference.isEmpty()) {
                return;
            }
            Holder.Reference<EnchantmentCategory> category = reference.get();
            if (!category.isBound() || !EnchantmentCategoryUtil.categoryAcceptsNewEnchantments(category, mutable.toImmutable())) {
                return;
            }
            mutable.overwrite((Holder<EnchantmentCategory>)category, (Holder<Enchantment>)enchantment);
        }));
    }

    public static void removeInvalidEnchantmentsFromItem(ItemStack stack) {
        DataComponentType<ItemEnchantments> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        if (((ItemEnchantments)stack.getOrDefault(enchantmentComponent, (Object)ItemEnchantments.EMPTY)).isEmpty() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        DataComponentType<ItemEnchantments> enchantmentsComponentType = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        stack.update(enchantmentsComponentType, (Object)ItemEnchantments.EMPTY, itemEnchantments -> {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
            mutable.removeIf(enchantment -> {
                if (EnchantmentCategoryUtil.getOptionalFirstEnchantmentCategory((HolderLookup.Provider)Enchiridion.getHelper().getRegistryAccess(), (Holder<Enchantment>)enchantment).isEmpty()) {
                    return false;
                }
                return !((ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).contains((Holder<Enchantment>)enchantment);
            });
            return mutable.toImmutable();
        });
    }

    private static void categoriseStoredEnchantmentsOnItem(ItemEnchantments enchantments, ItemStack stack, List<Holder<Enchantment>> missingEnchantments) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() || missingEnchantments.isEmpty()) {
            return;
        }
        HashMap usedEnchantmentTags = new HashMap();
        enchantments.keySet().stream().filter(enchantment -> ((ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).contains((Holder<Enchantment>)enchantment)).forEach(enchantment -> {
            if (!enchantment.isBound()) {
                return;
            }
            HolderSet tag = ((Enchantment)enchantment.value()).definition().primaryItems().orElse(((Enchantment)enchantment.value()).definition().supportedItems());
            Holder<EnchantmentCategory> category = ((ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).findFirstCategory((Holder<Enchantment>)enchantment);
            usedEnchantmentTags.computeIfAbsent(category, c -> new HashSet()).add(tag);
        });
        EnchantmentCategoryUtil.updateCategories(stack, categories -> missingEnchantments.forEach(enchantment -> {
            block2: {
                List<Holder> applicableCategories = EnchantmentCategoryUtil.getAllEnchantmentCategories((HolderLookup.Provider)Enchiridion.getHelper().getRegistryAccess(), (Holder<Enchantment>)enchantment).stream().sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority())).toList();
                if (applicableCategories.isEmpty()) {
                    return;
                }
                Iterator<Holder> iterator = applicableCategories.iterator();
                if (!iterator.hasNext()) break block2;
                Holder category = iterator.next();
                HolderSet tag = ((Enchantment)enchantment.value()).definition().primaryItems().orElse(((Enchantment)enchantment.value()).definition().supportedItems());
                if (!category.isBound() || categories.contains((Holder<Enchantment>)enchantment) && categories.contains((Holder<EnchantmentCategory>)category, (Holder<Enchantment>)enchantment) || usedEnchantmentTags.containsKey(category) && ((Set)usedEnchantmentTags.get(category)).stream().anyMatch(holders -> holders.stream().anyMatch(arg_0 -> ((HolderSet)tag).contains(arg_0)))) {
                    return;
                }
                categories.overwrite((Holder<EnchantmentCategory>)category, (Holder<Enchantment>)enchantment);
                usedEnchantmentTags.computeIfAbsent(category, c -> new HashSet()).add(tag);
            }
        }));
    }

    @Nullable
    public static Pair<Holder<Enchantment>, Integer> getFirstEnchantmentAndLevel(HolderLookup.Provider registries, ItemEnchantments enchantments, ItemEnchantmentCategories categories) {
        Optional tooltipOrderTag = registries.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.TOOLTIP_ORDER);
        Optional<Pair> enchantment = Stream.concat(tooltipOrderTag.map(HolderSet.ListBacked::stream).orElse(Stream.empty()), registries.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(e -> tooltipOrderTag.isEmpty() || !((HolderSet.Named)tooltipOrderTag.get()).contains((Holder)e))).filter(holder -> enchantments.keySet().contains(holder)).max((o1, o2) -> {
            Holder firstCategory = Optional.ofNullable(categories.findFirstCategory((Holder<Enchantment>)o1)).orElseGet(() -> Enchiridion.CONFIG.get() != null && ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() ? registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).getOrThrow(EnchiridionEnchantmentCategories.UNCATEGORISED) : null);
            Holder secondCategory = Optional.ofNullable(categories.findFirstCategory((Holder<Enchantment>)o2)).orElseGet(() -> Enchiridion.CONFIG.get() != null && ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() ? registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).getOrThrow(EnchiridionEnchantmentCategories.UNCATEGORISED) : null);
            int firstCategoryPriority = firstCategory != null ? ((EnchantmentCategory)firstCategory.value()).priority() : 0;
            int secondCategoryPriority = secondCategory != null ? ((EnchantmentCategory)secondCategory.value()).priority() : 0;
            return Integer.compare(firstCategoryPriority, secondCategoryPriority);
        }).map(holder -> Pair.of((Object)holder, (Object)enchantments.getLevel(holder)));
        return enchantment.orElse(null);
    }

    @Nullable
    public static Holder<EnchantmentCategory> getFirstEnchantmentCategory(HolderLookup.Provider registries, ItemEnchantments enchantments, ItemEnchantmentCategories categories) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() || enchantments.isEmpty()) {
            return null;
        }
        Pair<Holder<Enchantment>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(registries, enchantments, categories);
        return Optional.ofNullable(enchantment).map(pair -> categories.findFirstCategory((Holder<Enchantment>)((Holder)pair.getFirst()))).filter(Holder::isBound).orElse((Holder)registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).getOrThrow(EnchiridionEnchantmentCategories.UNCATEGORISED));
    }

    public static Holder<EnchantmentCategory> getFirstEnchantmentCategory(HolderLookup.Provider registries, Holder<Enchantment> enchantment) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories()) {
            return null;
        }
        return (Holder)EnchantmentCategoryUtil.getOptionalFirstEnchantmentCategory(registries, enchantment).orElse((Holder.Reference<EnchantmentCategory>)registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).getOrThrow(EnchiridionEnchantmentCategories.UNCATEGORISED));
    }

    public static Optional<Holder.Reference<EnchantmentCategory>> getOptionalFirstEnchantmentCategory(HolderLookup.Provider registries, Holder<Enchantment> enchantment) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories()) {
            return Optional.empty();
        }
        return registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(category -> category.isBound() && ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority()));
    }

    public static List<Holder<EnchantmentCategory>> getAllEnchantmentCategories(HolderLookup.Provider registries, Holder<Enchantment> enchantment) {
        if (!((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories()) {
            return Collections.emptyList();
        }
        return registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(category -> category.isBound() && ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)).collect(Collectors.toList());
    }

    public static boolean isValidInCategory(HolderLookup.Provider registries, ItemEnchantmentCategories categories, Holder<Enchantment> enchantment) {
        Optional<Holder.Reference> category = registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(c -> c.isBound() && ((EnchantmentCategory)c.value()).acceptedEnchantments().contains(enchantment)).max(Comparator.comparingInt(o -> ((EnchantmentCategory)o.value()).priority()));
        return category.map(enchantmentCategory -> EnchantmentCategoryUtil.isValidInCategory((Holder<EnchantmentCategory>)enchantmentCategory, categories.get((Holder<EnchantmentCategory>)enchantmentCategory), enchantment)).orElse(true);
    }

    public static boolean isValidInCategory(Holder<EnchantmentCategory> category, List<Holder<Enchantment>> enchantments, Holder<Enchantment> enchantment) {
        if (!(enchantments = new ArrayList<Holder<Enchantment>>(enchantments)).contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return category.isBound() && (((EnchantmentCategory)category.value()).limit().isEmpty() || enchantments.subList(0, enchantments.indexOf(enchantment)).size() < ((EnchantmentCategory)category.value()).limit().get());
    }

    public static boolean categoryAcceptsNewEnchantments(Holder<EnchantmentCategory> category, ItemEnchantmentCategories categories) {
        if (!category.isBound() || ((EnchantmentCategory)category.value()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, List.copyOf((Collection)categories.getCategories().get(category)));
    }

    public static boolean categoryAcceptsNewEnchantmentsWithValue(Holder<EnchantmentCategory> category, ItemEnchantmentCategories categories, Holder<Enchantment> enchantment) {
        if (!category.isBound() || ((EnchantmentCategory)category.value()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        ArrayList<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>((Collection)categories.getCategories().get(category));
        if (!enchantments.contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, enchantments);
    }

    private static boolean categoryAcceptsNewEnchantmentsInternal(Holder<EnchantmentCategory> category, List<Holder<Enchantment>> holders) {
        return category.isBound() && (((EnchantmentCategory)category.value()).limit().isEmpty() || holders.size() <= ((EnchantmentCategory)category.value()).limit().get());
    }
}

