/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.Nullable;

public class FloatRange {
    private static final Codec<FloatRange> RECORD_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NumberProviders.CODEC.optionalFieldOf("min").forGetter(range -> Optional.ofNullable(range.min)), (App)NumberProviders.CODEC.optionalFieldOf("max").forGetter(range -> Optional.ofNullable(range.max))).apply((Applicative)inst, FloatRange::new));
    public static final Codec<FloatRange> CODEC = Codec.either((Codec)Codec.DOUBLE, (Codec)RECORD_CODEC.validate(range -> {
        if (range.min == null && range.max == null) {
            return DataResult.error(() -> "FloatRange requires a 'min' or a 'max' field.");
        }
        return DataResult.success((Object)range);
    })).xmap(either -> (FloatRange)either.map(aDouble -> FloatRange.exact(aDouble.floatValue()), Function.identity()), range -> {
        OptionalDouble optionalDouble = range.unpackExact();
        return optionalDouble.isPresent() ? Either.left((Object)optionalDouble.getAsDouble()) : Either.right((Object)range);
    });
    @Nullable
    private final NumberProvider min;
    @Nullable
    private final NumberProvider max;
    private final DoubleLimiter limiter;
    private final DoubleChecker predicate;

    private FloatRange(Optional<NumberProvider> min, Optional<NumberProvider> max) {
        this((NumberProvider)min.orElse(null), (NumberProvider)max.orElse(null));
    }

    private FloatRange(@Nullable NumberProvider min, @Nullable NumberProvider max) {
        this.min = min;
        this.max = max;
        if (min == null) {
            if (max == null) {
                this.limiter = (context, value) -> value;
                this.predicate = (context, value) -> true;
            } else {
                this.limiter = (context, value) -> Math.min(max.getFloat(context), value);
                this.predicate = (context, value) -> value <= max.getFloat(context);
            }
        } else if (max == null) {
            this.limiter = (context, value) -> Math.max(min.getFloat(context), value);
            this.predicate = (context, value) -> value >= min.getFloat(context);
        } else {
            this.limiter = (context, value) -> Mth.clamp((float)value, (float)min.getFloat(context), (float)max.getFloat(context));
            this.predicate = (context, value) -> value >= min.getFloat(context) && value <= max.getFloat(context);
        }
    }

    public static FloatRange exact(float exactValue) {
        ConstantValue constantvalue = ConstantValue.exactly((float)exactValue);
        return new FloatRange(Optional.of(constantvalue), Optional.of(constantvalue));
    }

    public static FloatRange range(float min, float max) {
        return new FloatRange(Optional.of(ConstantValue.exactly((float)min)), Optional.of(ConstantValue.exactly((float)max)));
    }

    public static FloatRange lowerBound(float min) {
        return new FloatRange(Optional.of(ConstantValue.exactly((float)min)), Optional.empty());
    }

    public static FloatRange upperBound(float max) {
        return new FloatRange(Optional.empty(), Optional.of(ConstantValue.exactly((float)max)));
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.min != null) {
            builder.addAll((Iterable)this.min.getReferencedContextParams());
        }
        if (this.max != null) {
            builder.addAll((Iterable)this.max.getReferencedContextParams());
        }
        return builder.build();
    }

    public float clamp(LootContext context, float value) {
        return this.limiter.apply(context, value);
    }

    public boolean test(LootContext context, float value) {
        return this.predicate.test(context, value);
    }

    public double difference(LootContext context, float value) {
        if (this.max != null) {
            if (this.min != null) {
                return Math.min(Math.abs(this.min.getFloat(context) - value), Math.abs(this.max.getFloat(context) - value));
            }
            return Math.abs(this.max.getFloat(context) - value);
        }
        if (this.min == null) {
            throw new NullPointerException("FloatRange must have a min or max value.");
        }
        return Math.abs(this.min.getFloat(context) - value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OptionalDouble unpackExact() {
        OptionalDouble optionalDouble;
        NumberProvider numberProvider;
        if (Objects.equals(this.min, this.max) && (numberProvider = this.min) instanceof ConstantValue) {
            float value;
            ConstantValue constantValue = (ConstantValue)numberProvider;
            try {
                float f;
                value = f = constantValue.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            optionalDouble = OptionalDouble.of(value);
            return optionalDouble;
        }
        optionalDouble = OptionalDouble.empty();
        return optionalDouble;
    }

    @FunctionalInterface
    static interface DoubleLimiter {
        public float apply(LootContext var1, float var2);
    }

    @FunctionalInterface
    static interface DoubleChecker {
        public boolean test(LootContext var1, float var2);
    }
}

